package clinical.web.download;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;


import clinical.web.common.UserInfo;
import clinical.web.scheduler.IJob;
import clinical.web.scheduler.IJobEventListener;
import clinical.web.scheduler.JobException;
import clinical.web.scheduler.JobScheduler;
import clinical.web.scheduler.JobSchedulerException;
import clinical.web.scheduler.JobVisitContext;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AbstractJob.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public abstract class AbstractJob implements IJob {
	protected String id;
	protected UserInfo ui;
	protected String description;
	protected String dbID;
	protected boolean canceled = false;
	protected List<IJobEventListener> listeners = new ArrayList<IJobEventListener>(1);

	
	public AbstractJob(String id, UserInfo ui, String description, String dbID) {
		super();
		this.id = id;
		this.ui = ui;
		this.description = description;
		this.dbID = dbID;
	}

	public synchronized void cancel() {
		canceled = true;
	}
	
	
	public synchronized boolean isCanceled() {
		return canceled;
	}

	public int getNumberOfStages() {
		return 1;
	}
	
	public abstract void execute(int stageId) throws JobException;
	
	public String getDbID() {
		return dbID;
	}

	public String getDescription() {
		return description;
	}

	public String getID() {
		return id;
	}

	public abstract String[] getResultsFiles();
	
	public abstract String getType();


	public String getUser() {
		return ui.getPerceivedName();
	}

	public UserInfo getUserInfo() {
		return ui;
	}

	public abstract void saveResults(File file) throws JobException;

	protected void cleanupCache(String jobID, Log log) {
		try {
			JobScheduler.getInstance().cleanupCache(jobID);
		} catch (JobSchedulerException e) {
			log.error("cleanupCache",e);
		}
	}
	
	public void addJobEventListener(IJobEventListener listener) {
		listeners.add(listener);
	}
	
	public void shutdown() {
		listeners = null;
	}
	
	public List<JobVisitContext> getJobVisitContextList() {
		return new ArrayList<JobVisitContext>(0);
	}
	
	public String getContextAsJSON() {
		return null;
	}
}
