package clinical.web.forms;

import org.apache.struts.action.ActionForm;

import clinical.web.common.security.DBConfig;
import clinical.web.helpers.DbUserSelector;

/**
 * @author I. Burak Ozyurt
 * @version $Id: UserConfigForm.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class UserConfigForm extends ActionForm {
	protected String userType;
	protected String userName;
	protected String password;
	protected String passwordRepeat;
	protected String dbUserName;
	protected String dbId;
	protected boolean testConnection = true;
	protected DbUserSelector dbUserSelector;
	protected DBConfig dbConfig;
	protected String opType;
	protected String testResult = "";
	protected String useGSI = "false";

	public final static String WEBUSER = "web";
	public final static String DBUSER = "db";
	private static final long serialVersionUID = 1L;

	public String getUserType() {
		return userType;
	}

	public String getUserName() {
		return userName;
	}

	public String getPassword() {
		return password;
	}

	public String getPasswordRepeat() {
		return passwordRepeat;
	}

	public String getDbUserName() {
		return dbUserName;
	}

	public String getDbId() {
		return dbId;
	}

	public boolean isTestConnection() {
		return testConnection;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public void setUserType(String userType) {
		this.userType = userType;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public void setPasswordRepeat(String passwordRepeat) {
		this.passwordRepeat = passwordRepeat;
	}

	public void setDbUserName(String dbUserName) {
		this.dbUserName = dbUserName;
	}

	public void setDbId(String dbId) {
		this.dbId = dbId;
	}

	public void setTestConnection(boolean testConnection) {
		this.testConnection = testConnection;
	}

	public DbUserSelector getDbUserSelector() {
		return dbUserSelector;
	}

	public void setDbUserSelector(DbUserSelector dbUserSelector) {
		this.dbUserSelector = dbUserSelector;
	}

	public DBConfig getDbConfig() {
		return dbConfig;
	}

	public void setDbConfig(DBConfig dbConfig) {
		this.dbConfig = dbConfig;
	}

	public boolean isWebUserType() {
		return userType.equals(WEBUSER);
	}

	public String getOpType() {
		return opType;
	}

	public void setOpType(String opType) {
		this.opType = opType;
	}

	public String getTestResult() {
		return testResult;
	}

	public void setTestResult(String testResult) {
		this.testResult = testResult;
	}

	public String getUseGSI() {
		return useGSI;
	}

	public void setUseGSI(String useGSI) {
		this.useGSI = useGSI;
	}

	
}
