package clinical.web.forms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import clinical.web.common.security.User;
import clinical.web.common.security.User.PrivilegeExperiments;
import clinical.web.common.security.User.ProjectPrivilegeStatus;
import clinical.web.vo.ExperimentInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UserProjectPrivMatrixMan.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class UserProjectPrivMatrixMan {
	List<ExperimentInfo> curDBExperiments;
	User webUser;
	List<UserProjectPrivMatrix> userProjectPrivMatrixList;

	public UserProjectPrivMatrixMan(List<ExperimentInfo> curDBExperiments,
			User webUser) {
		super();
		this.curDBExperiments = curDBExperiments;
		this.webUser = webUser;
		// determine the number of tables necessary
		int numExpsPerRow = 4;
		int numExps = curDBExperiments.size();
		int numOfRows = numExps / numExpsPerRow
				+ ((numExps % numExpsPerRow) > 0 ? 1 : 0);

		userProjectPrivMatrixList = new ArrayList<UserProjectPrivMatrix>(
				numOfRows);
		for (int i = 0; i < numOfRows; i++) {
			userProjectPrivMatrixList.add(new UserProjectPrivMatrix(
					webUser, numExpsPerRow));
		}
		int rowIdx = 0;
		int count = 0;
		int idx = 0;

		Map<String, ProjectPrivilegeStatus> ppStatusMap = new HashMap<String, ProjectPrivilegeStatus>(
				11);

		for (Iterator<ExperimentInfo> it = curDBExperiments.iterator(); it
				.hasNext();) {
			ExperimentInfo ei = it.next();
			if (count >= numExpsPerRow) {
				rowIdx++;
				count = 0;
			}
			UserProjectPrivMatrix matrix = userProjectPrivMatrixList
					.get(rowIdx);

			ppStatusMap.clear();
			for (PrivilegeExperiments pe : webUser.getPrivExperiments()) {
				ppStatusMap.put(pe.getPrivilege(), pe.getPpStatusList()
						.get(idx));
			}
			matrix.add(ei, ppStatusMap);
			count++;
			idx++;
		}
	}

	public List<UserProjectPrivMatrix> getUserProjectPrivMatrixList() {
		return userProjectPrivMatrixList;
	}

}