package clinical.web.helpers;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.struts.util.LabelValueBean;
import org.jdom.Element;

import clinical.utils.GenUtils;

/**
 * Value object representing a (sub)cortical measurement metadata (region name,
 * laterality, measurement type , unit etc). Used in Query Builder wizard
 * screens, query result reporting layout generation etc.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubCorticalVarInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class SubCorticalVarInfo implements java.io.Serializable {
	private static final long serialVersionUID = 1011675140659558092L;
	String brainRegionName;
	Collection<LabelValueBean> lateralities;
	String laterality;
	String measurementType;
	String unit;
	int lidx;
	boolean selected;
	public final static int LEFT = 0;
	public final static int RIGHT = 1;

	public SubCorticalVarInfo(String brainRegionName, String[] latValues,
			String measurementTtpe, String unit) {
		this.brainRegionName = brainRegionName;
		this.measurementType = measurementTtpe;
		this.unit = unit;
		if (latValues != null && latValues.length > 0) {
			lateralities = new LinkedList<LabelValueBean>();
			for (int i = 0; i < latValues.length; i++) {
				lateralities.add(new LabelValueBean(latValues[i], String
						.valueOf(i)));
			}
		}
	}

	public SubCorticalVarInfo(String brainRegionName, String laterality,
			String measurementType, String unit) {
		this.brainRegionName = brainRegionName;
		this.laterality = laterality;
		this.measurementType = measurementType;
		this.unit = unit;
	}

	public void setBrainRegionName(String newBrainRegionName) {
		this.brainRegionName = newBrainRegionName;
	}

	public void setLaterality(String newLaterality) {
		this.laterality = newLaterality;
	}

	public void setSelected(boolean newSelected) {
		this.selected = newSelected;
	}

	public void setMeasurementType(String newMeasurementType) {
		this.measurementType = newMeasurementType;
	}

	public void setUnit(String newUnit) {
		this.unit = newUnit;
	}

	public String getBrainRegionName() {
		return this.brainRegionName;
	}

	public String getLaterality() {
		return this.laterality;
	}

	public boolean isSelected() {
		return this.selected;
	}

	public String getMeasurementType() {
		return this.measurementType;
	}

	public String getUnit() {
		return this.unit;
	}

	public void setLateralityAndLidx(String newLaterality) {
		this.laterality = newLaterality;
		setLaterality(newLaterality);
		int idx = 0;
		for (Iterator<LabelValueBean> iter = lateralities.iterator(); iter
				.hasNext();) {
			LabelValueBean lvb = iter.next();
			if (lvb.getLabel().equals(newLaterality)) {
				this.lidx = idx;
				break;
			}
			++idx;
		}
	}

	public void setLidx(int lidx) {
		this.lidx = lidx;
		LabelValueBean lvb = ((List<LabelValueBean>) lateralities).get(lidx);
		laterality = lvb.getLabel();
	}

	public int getLidx() {
		return this.lidx;
	}

	public String getLateralities(int lateralityIdx) {
		String latStr = String.valueOf(lateralityIdx);
		for (Iterator<LabelValueBean> iter = lateralities.iterator(); iter
				.hasNext();) {
			LabelValueBean lvb = iter.next();
			if (lvb.getValue().equals(latStr))
				return lvb.getLabel();

		}
		return null;
	}

	public Collection<LabelValueBean> getLateralities() {
		return lateralities;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(128);
		buf.append("SubCorticalVarInfo::[ brainRegionName=").append(
				brainRegionName);
		buf.append(" laterality=").append(laterality).append(
				" measurementType=").append(measurementType);
		buf.append(" unit=").append(unit).append("]");
		return buf.toString();
	}

	public int hashCode() {
		StringBuffer buf = new StringBuffer();
		buf.append(brainRegionName).append('_').append(laterality);
		return buf.toString().hashCode();
	}

	public boolean equals(Object other) {
		if (other == null || !(other instanceof SubCorticalVarInfo))
			return false;
		SubCorticalVarInfo sv = (SubCorticalVarInfo) other;
		return brainRegionName.equals(sv.brainRegionName)
				&& laterality.equals(sv.laterality);
	}

	public Element toXML() {
		Element elem = new Element("subcortical-var-info");
		elem.setAttribute("name", brainRegionName);
		elem.setAttribute("selected", String.valueOf(selected));
		if (laterality != null)
			elem.setAttribute("laterality", laterality);
		if (measurementType != null)
			elem.setAttribute("measurement-type", measurementType);
		// elem.setAttribute("lidx", String.valueOf(lidx));
		if (unit != null)
			elem.setAttribute("unit", unit);
		if (lateralities != null) {
			for (Iterator<LabelValueBean> iter = lateralities.iterator(); iter
					.hasNext();) {
				LabelValueBean lbv = iter.next();
				Element e = new Element("lateral");
				e.addContent(lbv.getLabel());
				elem.addContent(e);
			}
		}
		return elem;
	}

	public static SubCorticalVarInfo initializeFromXML(Element elem) {
		String brainRegionName = elem.getAttributeValue("name");
		String measurementType = null;
		String unit = null;
		if (elem.getAttribute("measurement-type") != null)
			measurementType = elem.getAttributeValue("measurement-type");
		if (elem.getAttribute("unit") != null)
			unit = elem.getAttributeValue("unit");

		SubCorticalVarInfo scvi = null;
		if (elem.getAttribute("laterality") != null) {
			String laterality = elem.getAttributeValue("laterality");
			scvi = new SubCorticalVarInfo(brainRegionName, laterality,
					measurementType, unit);
		} else {
			List<?> children = elem.getChildren("lateral");
			if (children != null) {
				String[] laterals = new String[children.size()];
				int idx = 0;
				for (Iterator<?> iter = children.iterator(); iter.hasNext();) {
					Element e = (Element) iter.next();
					laterals[idx++] = e.getTextTrim();
				}
				scvi = new SubCorticalVarInfo(brainRegionName, laterals,
						measurementType, unit);
			}
		}

		scvi.setSelected(GenUtils.toBoolean(elem.getAttributeValue("selected"),
				false));

		return scvi;
	}

}
