package clinical.web.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Experiment;

public class UsageExperimentSelector implements Serializable {
	private static final long serialVersionUID = 1L;
	protected Collection<LabelValueBean> experimentInfos;
	private int selectedExpID;
	
	public UsageExperimentSelector(List<Experiment> experiments) {
		experimentInfos = new ArrayList<LabelValueBean>(experiments.size());
		boolean first = true;
		for (Experiment exp : experiments) {
			LabelValueBean lvb = new LabelValueBean(exp.getName(), exp.getUniqueid()
					.toString());
			experimentInfos.add(lvb);
			if (first) {
				first = false;
				this.setSelectedExpID(exp.getUniqueid().intValue());
			}
		}
	}

	public void setSelectedExpID(int selectedExpID) {
		this.selectedExpID = selectedExpID;
	}

	public int getSelectedExpID() {
		return selectedExpID;
	}

	public Collection<LabelValueBean> getExperimentInfos() {
		return experimentInfos;
	}

}
