package clinical.web.scheduler;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: JobInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class JobInfo {
	protected IJob job;
	protected String status;
	protected String statusDetail;
	protected String errorMsg;
	public final static String NOT_STARTED = "not_started";
	public final static String RUNNING = "running";
	public final static String FINISHED = "finished";
	public final static String FINISHED_WITH_ERR = "finished_with_err";
	public final static String REMOVED = "removed";
	public final static String CANCELED = "canceled";
	public final static String WAITING = "waiting";
	/**
	 * The Job is waiting for user action far too long and is shelved for later
	 * resurrection
	 */
	public final static String SHELVED = "shelved";

	public JobInfo(IJob job) {
		this.job = job;
		status = NOT_STARTED;
	}

	public IJob getJob() {
		return job;
	}

	public String getStatus() {
		return status;
	}

	void setStatus(String status) {
		this.status = status;
	}

	public String getErrorMsg() {
		return errorMsg;
	}

	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}

	public String getStatusDetail() {
		return statusDetail;
	}

	public void setStatusDetail(String statusDetail) {
		this.statusDetail = statusDetail;
	}

}