package clinical.web.scheduler.remote;

import java.util.List;

import org.json.JSONObject;

import clinical.web.ConnectionSupportMixin;
import clinical.web.IJobManagementService;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.scheduler.JobRecord;
import clinical.web.services.SecurityService;
import clinical.web.workflow.cbf.CBFWFContext;
import clinical.web.workflow.cbf.remote.CBFWFContextWrapper;

public class WFESCBFTestStub {
	private ConnectionSupportMixin csm;
	
	public WFESCBFTestStub() {
	}
	
	public void startup() throws Exception {
		csm = new ConnectionSupportMixin("users.xml");
		csm.startup();
		SecurityService ss = SecurityService.getInstance(
				csm.getDbPoolService(), csm.getDbID(), csm.getDbType());
		ss.startup();
	}
	
	public void shutdown() throws Exception {
		if (csm != null) {
			csm.shutdown();
		}
	}
	
	public CBFWFContextWrapper getACBFWFContext(String jobUser) throws Exception {
		UserInfo ui = csm.getUi();
		String dbID = csm.getDbID();
		
		IJobManagementService jms = ServiceFactory.getJobManagementService(dbID);
		List<JobRecord> jobs = jms.getJobsForUser(ui, jobUser);
		if (jobs.isEmpty()) {
			return null;
		}
		JobRecord jr = jobs.get(0);
		
		JSONObject js = new JSONObject(jr.getContext());
		CBFWFContext ctx = CBFWFContext.fromJSON(js);
		return new CBFWFContextWrapper(ctx, jr.getJobID());
	}
}
