package clinical.web.services;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import clinical.server.dao.DatabaseuserDAO;
import clinical.server.dao.PersonDAO;
import clinical.server.dao.UserclassDAO;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Person;
import clinical.server.vo.Tableid;
import clinical.server.vo.Userclass;
import clinical.server.vo.Userstatus;
import clinical.utils.Assertion;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.IDBUserManService;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.IDBPoolService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;
import clinical.web.exception.BaseException;

public class DBUserManServiceImpl extends AbstractServiceImpl implements
		IDBUserManService {

	public DBUserManServiceImpl(String dbID) throws BaseException {
		super(dbID);
	}

	public void prepareKeyers(DBConfig dbConfig) throws Exception {
		String dbID = dbConfig.getId();
		IDBPoolService pool = ServiceFactory.getPoolService(dbID);
		Map<String, User> userMap = dbConfig.getUserMap();
		UserInfo ui = new UserInfo(Constants.ADMIN_USER, null, null);
		User ownerUser = userMap.get(Constants.ADMIN_USER).getDbUser();
		Connection con = null;

		try {
			con = pool.getConnection(ui.getName());
			con.setAutoCommit(false);
			Userclass ucCrit = new Userclass();
			ucCrit.setUserclass(Constants.USERCLASS_DATA_PROCESSING);
			UserclassDAO ucDAO = DAOFactory.createUserclassDAO(dbID);
			List<Userclass> ucList = ucDAO.find(con, ucCrit);
			Userclass uc = null;
			if (ucList.isEmpty()) {
				uc = insertUserClass(con, dbID, ui, ownerUser,
						Constants.USERCLASS_DATA_PROCESSING);
			} else {
				uc = ucList.get(0);
			}

			Databaseuser duCrit = new Databaseuser();
			duCrit.setIsgroup(new Boolean(false));
			duCrit.setUserclass(uc.getUniqueid());

			DatabaseuserDAO duDAO = DAOFactory.createDatabaseuserDAO(dbID);
			List<Databaseuser> duList = duDAO.find(con, duCrit);
			Map<String, Databaseuser> existingDUMap = new HashMap<String, Databaseuser>(
					23);
			for (Databaseuser du : duList) {
				existingDUMap.put(du.getName(), du);
			}

			for (User webUser : userMap.values()) {
				log.info("-- webUser = " + webUser);
				if (existingDUMap.get(webUser.getName().toUpperCase()) == null) {
					// insert a new record into
					log.info("inserting webUser " + webUser);
					insertDatabaseUser(con, dbID, webUser, uc, ui, ownerUser);
				}
			}
			con.commit();
		} catch (Exception e) {
			handleErrorAndRollBack(con, "Error in prepareKeyers", e, true);
		} finally {
			if (con != null)
				pool.releaseConnection(Constants.ADMIN_USER, con);
		}
	}

	public Person findOrInsertPerson(Connection con, String dbID, UserInfo ui,
			User owner, String firstName, String lastName, String email,
			String userClass) throws Exception {
		IDBCache dbCache = ServiceFactory.getDBCache(dbID);
		Databaseuser databaseUser = dbCache.getDatabaseUser(ui,
				owner.getName(), Constants.USERCLASS_ADMIN);
		Tableid tableID = dbCache.getTableID(ui, Constants.PERSON_DB_TABLE);

		PersonDAO dao = DAOFactory.createPersonDAO(dbID);
		Person person = new Person();
		person.setFirstName(firstName);
		person.setLastName(lastName);

		List<?> personList = dao.find(con, person);
		if (!personList.isEmpty()) {
			return (Person) personList.get(0);
		}

		person.setEmail(email);
		person.setOwner(databaseUser.getUniqueid());
		person.setModuser(databaseUser.getUniqueid());
		person.setModtime(new java.util.Date());
		person.setTableid(tableID.getTableid());
		person.setUniqueid(ServiceFactory.getSequenceHelper(dbID).getNextUID(
				ui, Constants.PERSON_DB_TABLE, "uniqueid"));

		dao.insert(con, person);
		return person;
	}

	public Userclass insertUserClass(Connection con, String dbID, UserInfo ui,
			User owner, String userClass) throws Exception {
		IDBCache dbCache = ServiceFactory.getDBCache(dbID);
		Databaseuser databaseUser = dbCache.getDatabaseUser(ui,
				owner.getName(), Constants.USERCLASS_ADMIN);
		Tableid tableID = dbCache.getTableID(ui, Constants.USERCLASS_DB_TABLE);
		UserclassDAO ucDAO = DAOFactory.createUserclassDAO(dbID);
		Userclass uc = new Userclass();
		uc.setName(userClass);
		uc.setUserclass(userClass);
		uc.setDescription(userClass);
		uc.setOwner(databaseUser.getUniqueid());
		uc.setModuser(databaseUser.getUniqueid());
		uc.setModtime(new java.util.Date());
		uc.setTableid(tableID.getTableid());
		BigDecimal uniqueID = ServiceFactory.getSequenceHelper(dbID)
				.getNextUID(ui, Constants.USERCLASS_DB_TABLE, "uniqueid");
		uc.setUniqueid(uniqueID);

		ucDAO.insert(con, uc);
		return uc;
	}

	public Databaseuser insertDatabaseUser(Connection con, String dbID,
			User webUser, Userclass uc, UserInfo ui, User owner)
			throws Exception {
		IDBCache dbCache = ServiceFactory.getDBCache(dbID);
		Databaseuser databaseUser = dbCache.getDatabaseUser(ui,
				owner.getName(), Constants.USERCLASS_ADMIN);
		Tableid tableID = dbCache.getTableID(ui,
				Constants.DATABASEUSER_DB_TABLE);
		List<Userstatus> userStatusList = dbCache.getUserStatusList(ui, true);
		Userstatus active = null;
		for (Userstatus us : userStatusList) {
			if (us.getUserstatus().equalsIgnoreCase("active")) {
				active = us;
				break;
			}
		}
		assert (active != null);
		// check if there is a person record for the database user to be added
		Person person = findOrInsertPerson(con, dbID, ui, owner,
				webUser.getName(), "", "no-email", uc.getName());

		DatabaseuserDAO duDAO = DAOFactory.createDatabaseuserDAO(dbID);

		Databaseuser du = new Databaseuser();
		du.setIsgroup(new Boolean(false));
		du.setModtime(new java.util.Date());
		du.setName(webUser.getName().toUpperCase());
		du.setUserclass(uc.getUniqueid());
		du.setUserstatus(active.getUniqueid());
		du.setTableid(tableID.getTableid());
		du.setOwner(databaseUser.getUniqueid());
		du.setModuser(databaseUser.getUniqueid());
		BigDecimal uniqueID = ServiceFactory.getSequenceHelper(dbID)
				.getNextUID(ui, Constants.DATABASEUSER_DB_TABLE, "uniqueid");
		du.setUniqueid(uniqueID);
		du.setPersonid(person.getUniqueid());
		duDAO.insert(con, du);
		return du;
	}

	public Databaseuser findOrInsertDatabaseUser(Connection con, String dbID,
			User webUser, Userclass uc, UserInfo ui, User owner)
			throws Exception {
		IDBCache dbCache = ServiceFactory.getDBCache(dbID);
		Databaseuser databaseUser = dbCache.getDatabaseUser(ui,
				owner.getName(), Constants.USERCLASS_ADMIN);
		Tableid tableID = dbCache.getTableID(ui,
				Constants.DATABASEUSER_DB_TABLE);
		List<Userstatus> userStatusList = dbCache.getUserStatusList(ui, true);
		Userstatus active = null;
		for (Userstatus us : userStatusList) {
			if (us.getUserstatus().equalsIgnoreCase("active")) {
				active = us;
				break;
			}
		}
		Assertion.assertNotNull(active);

		Databaseuser existingDU = dbCache.getDatabaseUser(ui, webUser.getName()
				.toUpperCase(), uc.getName());
		if (existingDU != null) {
			return existingDU;
		}

		// check if there is a person record for the database user to be added
		Person person = findOrInsertPerson(con, dbID, ui, owner,
				webUser.getName(), "", "no-email", uc.getName());

		DatabaseuserDAO duDAO = DAOFactory.createDatabaseuserDAO(dbID);

		Databaseuser du = new Databaseuser();
		du.setIsgroup(new Boolean(false));
		du.setModtime(new java.util.Date());
		du.setName(webUser.getName().toUpperCase());
		du.setUserclass(uc.getUniqueid());
		du.setUserstatus(active.getUniqueid());
		du.setTableid(tableID.getTableid());
		du.setOwner(databaseUser.getUniqueid());
		du.setModuser(databaseUser.getUniqueid());
		BigDecimal uniqueID = ServiceFactory.getSequenceHelper(dbID)
				.getNextUID(ui, Constants.DATABASEUSER_DB_TABLE, "uniqueid");
		du.setUniqueid(uniqueID);
		du.setPersonid(person.getUniqueid());
		duDAO.insert(con, du);
		return du;
	}

	public Databaseuser ensureClinicalRater(Connection con, UserInfo ui,
			String clinicalRater) throws Exception {
		IDBCache dbCache = ServiceFactory.getDBCache(theDBID);
		DatabaseuserDAO duDAO = DAOFactory.createDatabaseuserDAO(theDBID);
		UserclassDAO ucDAO = DAOFactory.createUserclassDAO(theDBID);

		List<Userstatus> userStatusList = dbCache.getUserStatusList(ui, true);
		Userstatus active = null;
		for (Userstatus us : userStatusList) {
			if (us.getUserstatus().equalsIgnoreCase("active")) {
				active = us;
				break;
			}
		}
		Assertion.assertNotNull(active);

		Userclass ucCrit = new Userclass();
		ucCrit.setUserclass(Constants.USERCLASS_RESEARCHER);
		List<Userclass> ucList = ucDAO.find(con, ucCrit);
		Userclass uc = null;
		if (!ucList.isEmpty()) {
			uc = ucList.get(0);
			Databaseuser cr = new Databaseuser();
			cr.setIsgroup(false);
			cr.setUserclass(uc.getUniqueid());
			cr.setName(clinicalRater);
			cr.setUserstatus(active.getUniqueid());
			List<Databaseuser> duList = duDAO.find(con, cr);
			if (!duList.isEmpty()) {
				return duList.get(0);
			}
		}
		Databaseuser adminDU = getDatabaseUser(ui, Constants.USERCLASS_ADMIN);
		User ownerUser = new User(adminDU.getName(), null, null);
		if (ucList.isEmpty()) {
			uc = insertUserClass(con, theDBID, ui, ownerUser,
					Constants.USERCLASS_RESEARCHER);
		}

		// FIXME check if findOrInsertDatabaseUser works
		//Databaseuser du = insertDatabaseUser(con, theDBID, new User(
		//		clinicalRater, null, null), uc, ui, ownerUser);

		Databaseuser du = findOrInsertDatabaseUser(con, theDBID, new User(
				clinicalRater, null, null), uc, ui, ownerUser);
		return du;
	}

	public Databaseuser ensureClinicalRater(UserInfo ui, String clinicalRater)
			throws Exception {
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			con.setAutoCommit(false);
			Databaseuser du = ensureClinicalRater(con, ui, clinicalRater);

			con.commit();
			return du;
		} catch (Throwable t) {
			handleErrorAndRollBack(con, "Error in ensureClinicalRater", t, true);
			return null;
		} finally {
			releaseConnection(con, ui);
		}
	}

}
