package clinical.web.services;

import java.io.File;
import java.util.List;
import java.util.Map;

import clinical.web.common.UserInfo;
import clinical.web.services.BatchAssessmentServiceImpl.CSVTable;
import clinical.web.vo.SubjectAsScoreValueSummary;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public interface IBatchAssessmentService {

	public Map<Integer, List<String>> prepExpSubjectIDListMap(UserInfo ui,
			List<String> expNames) throws Exception;

	public Map<Integer, List<String>> prepExpSubjectIDListMapFromExpIDs(
			UserInfo ui, List<Integer> expIds) throws Exception;

	public List<SubjectAsScoreValueSummary> getAllAssessmentValues(UserInfo ui,
			Map<Integer, List<String>> expSubjectIDListMap) throws Exception;

	public void prepareCSVFile(UserInfo ui, File file,
			List<SubjectAsScoreValueSummary> sasvsList) throws Exception;

	public CSVTable prepCSVTable(UserInfo ui,
			List<SubjectAsScoreValueSummary> sasvsList) throws Exception;
}