package clinical.web.services;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import clinical.web.common.IAuthorizationService.PrivilegeLabel;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.common.vo.CBFProcessReportRec;
import clinical.web.common.vo.CBFProcessReportRecListWrapper;
import clinical.web.vo.AssessmentResultSummary;
import clinical.web.vo.CBFQueryMetaData;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public interface ICBFSearchService {

	public CBFQueryMetaData getMetadataQuery(UserInfo ui, String primarySiteID,
			PrivilegeLabel privilegeRequired) throws Exception;

	public List<CBFProcessReportRec> filterRecsByFilterQuery(UserInfo ui,
			JSONObject searchFilterJSON,
			CBFProcessReportRecListWrapper resultSet) throws Exception;

	public AssessmentSelectionInfo getAssessmentQueryMetadata(UserInfo ui,
			String assessmentName, String primarySiteID) throws Exception;

	public List<AssessmentResultSummary> searchByAssessment(UserInfo ui,
			JSONObject searchFilterJSON) throws Exception;

	public JSONObject getDistinctScoreValues(UserInfo ui, String asID,
			String scoreName) throws Exception;

	public List<CBFProcessReportRec> filterRecsByExperiment(UserInfo ui,
			JSONArray selExpIdsArr, CBFProcessReportRecListWrapper resultSet)
			throws Exception;

	public JSONObject getDistinctProvParamValues(UserInfo ui, String provName)
			throws Exception;

}