package clinical.web.soap;

import java.io.IOException;

import javax.jws.WebService;

import clinical.web.common.UserInfo;
import clinical.xml.ApplicationUtils;

/**
 * @author I. Burak Ozyurt
 * @version $Id: QueryAtlasServiceImpl.java 366 2011-05-05 20:06:27Z bozyurt $
 */

@WebService(endpointInterface = "clinical.web.soap.QueryAtlasService", 
		    serviceName = "QueryAtlasService", 
		    portName = "queryAtlasPort")
public class QueryAtlasServiceImpl implements QueryAtlasService {

	public String getDerivedDataStatsForSubject(String webUser, String pwd,
			String subjectID, int expID, String[] popSubjectIds) {
		SubcorticalStatsService statsService = null;
		String dbID = null;
		try {
			statsService = new SubcorticalStatsService();
			dbID = getDBID();
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			String result = statsService.getDerivedDataStatsForSubject(ui,
					dbID, subjectID, expID, popSubjectIds);
			return result;
		} catch (Exception x) {
			x.printStackTrace();
		}
		return "";
	}

	protected String getDBID() throws IOException, Exception {
		String dbID;
		dbID = ApplicationUtils.getProperty("fbirn.dbid");
		if (dbID == null) {
			throw new Exception(
					"Cannot detect data source! Possible misconfiguration!");
		}
		return dbID;
	}

}
