package clinical.web.tags.sec;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.UserContainer;
import clinical.web.common.IAuthorizationService;
import clinical.web.common.IAuthorizationService.PrivilegeLabel;
import clinical.web.exception.BaseException;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AuthorizedTag.java 565 2012-03-15 00:13:42Z bozyurt $
 */

public class AuthorizedTag extends TagSupport {
	private static final long serialVersionUID = 714421451938737030L;
	protected String privilege;

	public AuthorizedTag() {}

	public int doStartTag() throws JspException {
		HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
		HttpSession session = req.getSession(false);
		if (session == null)
			return SKIP_BODY;
		// check if there is a user container in the session (set after login
		// only)
		UserContainer userCon = (UserContainer) session
				.getAttribute(Constants.CONTAINER_KEY);

		if (userCon == null) {
			return SKIP_BODY;
		}

		try {
			if (privilege.equalsIgnoreCase("public")) {
				return EVAL_BODY_INCLUDE;
			}

			boolean negate = false;
			if (privilege.indexOf("not ") == 0) {
				negate = true;
				privilege = privilege.substring(4);
			}

			IAuthorizationService authService = ServiceFactory
					.getAuthorizationService();

			if (privilege.indexOf(",") != -1) {
				String[] privToks = privilege.split("\\s*,\\s*");
				if (!negate) {
					// OR operation
					for (String privTok : privToks) {
						String[] toks = getToks(privTok);
						Integer expID = getExpID(toks);
						PrivilegeLabel privilege = PrivilegeLabel.findByLabel(toks[0]);
						
						if (privilege != null && authService.isAuthorized(userCon.getUserInfo(), userCon
								.getDbID(), privilege, expID)) {
							return EVAL_BODY_INCLUDE;
						}
					}
					return SKIP_BODY;
				} else {
					// not A and not B and ...
					for (String privTok : privToks) {
						String[] toks = getToks(privTok);
						Integer expID = getExpID(toks);
						PrivilegeLabel privilege = PrivilegeLabel.findByLabel(toks[0]);
						if (authService.isAuthorized(userCon.getUserInfo(), userCon
								.getDbID(), privilege, expID)) {
							return SKIP_BODY;
						}
					}
				}

			} else {
				String[] toks = getToks(privilege);
				Integer expID = getExpID(toks);
				PrivilegeLabel privilege = PrivilegeLabel.findByLabel(toks[0]);
				boolean authenticated = authService.isAuthorized(userCon
						.getUserInfo(), userCon.getDbID(), privilege, expID);
				if (!negate && !authenticated) {
					return SKIP_BODY;
				}
				if (negate && authenticated) {
					return SKIP_BODY;
				}
			}
		} catch (BaseException be) {
			throw new JspTagException(be.getMessage());
		}

		return EVAL_BODY_INCLUDE;
	}

	Integer getExpID(String[] toks) {
		if (toks.length == 1)
			return null;
		return new Integer(Integer.parseInt(toks[1].trim()));
	}

	String[] getToks(String privTok) {
		if (privTok.indexOf(":") == -1) {
			return new String[] { privTok };
		}
		return privTok.split(":");
	}

	public void setPrivilege(String newPrivilege) {
		this.privilege = newPrivilege;
	}
}