package clinical.web.tags.sec;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.struts.Globals;
import org.apache.struts.config.ModuleConfig;

import clinical.web.Constants;
import clinical.web.UserContainer;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CheckLogonTag.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class CheckLogonTag extends TagSupport {
	private static final long serialVersionUID = -4651676363002620113L;
	private String page = Constants.INDEX_PAGE;

	// ---------------------- setters --------------
	public void setPage(String newPage)
	{
		this.page = newPage;
	}

	// ---------------------- getters --------------
	public String getPage()
	{
		return this.page;
	}

	public int doStartTag() throws JspException
	{
		// was SKIP_PAGE caught by Dingying Wei
		return SKIP_BODY;
	}

	public int doEndTag() throws JspException
	{
		boolean valid = false;
		HttpSession session = pageContext.getSession();
		if (session != null) {
			UserContainer userCon = (UserContainer) session
					.getAttribute(Constants.CONTAINER_KEY);
			if (userCon != null)
				valid = true;
		}
		if (valid)
			return EVAL_PAGE;
		ModuleConfig config = (ModuleConfig) pageContext.getServletContext()
				.getAttribute(Globals.MODULE_KEY);
		try {
			pageContext.forward(config.getPrefix() + getPage());
		} catch (ServletException se) {
			throw new JspTagException(se.toString());
		} catch (IOException iox) {
			throw new JspTagException(iox.toString());
		}
		return SKIP_PAGE;
	}

}