package clinical.web.upload;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UploadVisit.java 144 2010-01-19 00:08:21Z bozyurt $
 */
public class UploadVisit {
	private Visit visit;
	private String stagingDir;
	private String expName;
	private String protocolId;
	private int protocolVersion;
	/** as set for the experiment (e.g. patient,control etc) */
	private String subjectGroupID;
	private Map<VisitSegment, List<String>> visit2PointerMap = new HashMap<VisitSegment, List<String>>();

	public UploadVisit(Visit visit, String stagingDir, String expName,
			String protocolId, int protocolVersion, String subjectGroupID) {
		super();
		this.visit = visit;
		this.stagingDir = stagingDir;
		this.expName = expName;
		this.protocolId = protocolId;
		this.protocolVersion = protocolVersion;
		this.subjectGroupID = subjectGroupID;
	}

	public VisitSegment findVisitSegment(Date date) {
		for (VisitSegment vs : visit.getVisitSegments()) {
			if (vs.getTimeStamp().compareTo(date) == 0) {
				return vs;
			}
		}
		return null;
	}

	public void addPointer(VisitSegment vs, String logicalFilePointer) {
		List<String> pointerList = visit2PointerMap.get(vs);
		if (pointerList == null) {
			pointerList = new ArrayList<String>(2);
			visit2PointerMap.put(vs, pointerList);
		}
		pointerList.add(logicalFilePointer);
	}

	public List<String> getPointers(VisitSegment vs) {
		return visit2PointerMap.get(vs);
	}

	public Visit getVisit() {
		return visit;
	}

	public String getStagingDir() {
		return stagingDir;
	}

	public String getExpName() {
		return expName;
	}

	public String getProtocolId() {
		return protocolId;
	}

	public int getProtocolVersion() {
		return protocolVersion;
	}

	public String getSubjectGroupID() {
		return subjectGroupID;
	}
}
