package clinical.web.vo;

import java.util.ArrayList;
import java.util.List;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AnalysisInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class AnalysisInfo {
	protected String name;
	protected String version;
	protected String description;
	protected List<AnalysisCompInfo> componentList = new ArrayList<AnalysisCompInfo>(
			2);

	public AnalysisInfo(String name, String version) {
		this.name = name;
		this.version = version;
	}

	public String getName() {
		return name;
	}

	public String getVersion() {
		return version;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	
	public void addComponent(AnalysisCompInfo aci) {
		if (!componentList.contains(aci)) {
			componentList.add(aci);
		}
	}
	
	/**
	 * @deprecated
	 * maintain a forest of {@link AnalysisCompInfo} trees.
	 * 
	 * @param aci
	 */
	public void addComponent2Forest(AnalysisCompInfo aci) {
		if (aci.getParent() == null) {
			if (!componentList.contains(aci)) {
				componentList.add(aci);
			}
		} else {
			AnalysisCompInfo root = aci.getRoot();
			if (!componentList.contains(root)) {
				throw new IllegalArgumentException(
						"The root of this component branch is not in the forest!");
			}
		}
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("AnalysisInfo::[");
		buf.append("name=").append(name);
		buf.append(",version=").append(version);
		buf.append(']');
		return buf.toString();
	}

	public List<AnalysisCompInfo> getComponentList() {
		return componentList;
	}
}
