package clinical.web.vo;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class AssessmentInfo {
	protected int assessmentID;
	protected Date modTime;
	protected String name;
	protected String description;
	protected int visitID;
	protected int segmentID;
	protected List<ScoreInfo> scores = new LinkedList<ScoreInfo>();
	protected Map<String, ScoreInfo> scoresMap;
	protected boolean ordered = false;

	public AssessmentInfo(int assessmentID, String name, Date modTime,
			int visitID, int segmentID) {
		this.assessmentID = assessmentID;
		this.name = name;
		this.modTime = modTime;
		this.visitID = visitID;
		this.segmentID = segmentID;
	}

	public void addScore(ScoreInfo si) {
		scores.add(si);
	}

	public List<ScoreInfo> getScores() {
		if (!ordered) {
			Collections.sort(scores, new Comparator<ScoreInfo>() {
				public int compare(ScoreInfo si1, ScoreInfo si2) {
					return si1.getScoreSequence() - si2.getScoreSequence();
				}
			});
			ordered = true;
		}
		return scores;
	}

	public ScoreInfo findScore(String scoreName) {
		if (scoresMap == null) {
			scoresMap = new HashMap<String, ScoreInfo>(17);
			for (Iterator<ScoreInfo> iter = scores.iterator(); iter.hasNext();) {
				ScoreInfo si = iter.next();
				scoresMap.put(si.getName(), si);
			}
			// determine and set the parent of each score
			prepareScoreHierarchy();
		}

		return scoresMap.get(scoreName);
	}

	public void prepareScoreHierarchy() {
		// assuming same name is not repeated at different levels of hierarchy
		for (Iterator<ScoreInfo> iter = scoresMap.values().iterator(); iter
				.hasNext();) {
			ScoreInfo si = iter.next();
			ScoreInfo parent = scoresMap.get(si.parentScore);
			if (parent != null)
				si.setParent(parent);
		}
	}

	// ---------------------- setters --------------
	public void setAssessmentID(int newAssessmentID) {
		this.assessmentID = newAssessmentID;
	}

	public void setModTime(Date newModTime) {
		this.modTime = newModTime;
	}

	public void setName(String newName) {
		this.name = newName;
	}

	public void setDescription(String newDescription) {
		this.description = newDescription;
	}

	public void setVisitID(int newVisitID) {
		this.visitID = newVisitID;
	}

	public void setSegmentID(int newSegmentID) {
		this.segmentID = newSegmentID;
	}

	// ---------------------- getters --------------
	public int getAssessmentID() {
		return this.assessmentID;
	}

	public Date getModTime() {
		return this.modTime;
	}

	public String getName() {
		return this.name;
	}

	public String getDescription() {
		return this.description;
	}

	public int getVisitID() {
		return this.visitID;
	}

	public int getSegmentID() {
		return this.segmentID;
	}

	public String getAssessmentIDAsString() {
		return String.valueOf(assessmentID);
	}

	public static class ScoreInfo {
		String name;
		String type;
		int scoreSequence;
		int scoreLevel;
		ScoreInfo parent;
		int parentAsID;
		String parentScore;

		public ScoreInfo(String name, String type, int scoreLevel,
				int parentAsID, String parentScore, int scoreSequence) {
			this.name = name;
			this.type = type;
			this.scoreLevel = scoreLevel;
			this.parentAsID = parentAsID;
			this.parentScore = parentScore;
			this.scoreSequence = scoreSequence;

		}

		// ---------------------- setters --------------
		public void setName(String newName) {
			this.name = newName;
		}

		public void setType(String newType) {
			this.type = newType;
		}

		public void setScoreLevel(int newScoreLevel) {
			this.scoreLevel = newScoreLevel;
		}

		public void setParent(ScoreInfo newParent) {
			this.parent = newParent;
		}

		public void setScoreSequence(int newScoreSequence) {
			this.scoreSequence = newScoreSequence;
		}

		// ---------------------- getters --------------
		public String getName() {
			return this.name;
		}

		public String getType() {
			return this.type;
		}

		public int getScoreLevel() {
			return this.scoreLevel;
		}

		public int getScoreSequence() {
			return this.scoreSequence;
		}

		public ScoreInfo getParent() {
			return this.parent;
		}

		public String toString() {
			StringBuffer buf = new StringBuffer(128);
			buf.append("ScoreInfo::[name=").append(name).append(",type=")
					.append(type);
			buf.append(",level=").append(scoreLevel);
			buf.append(",parentScore=").append(parentScore);
			buf.append(']');
			return buf.toString();
		}
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(1024);
		buf.append("AssessmentInfo::[name=").append(name).append(",id=")
				.append(assessmentID);

		buf.append(']');
		for (Iterator<ScoreInfo> iter = scores.iterator(); iter.hasNext();) {
			ScoreInfo si = iter.next();
			buf.append("\n\t");
			buf.append(si.toString());
		}
		return buf.toString();
	}
}
