package clinical.web.vo;

import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import clinical.utils.Assertion;
import clinical.web.common.vo.Factor;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */

public class FactorRepeatedMeasureInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	private final Factor factor;
	private Map<String, BitSet> level2MeasureMap = new HashMap<String, BitSet>();
	// repeated measure to index map
	private final Map<String, Integer> rm2IdxMap;
	private Set<String> violatingLevelSet = new HashSet<String>(7);

	public FactorRepeatedMeasureInfo(Factor factor,
			Map<String, Integer> rm2IdxMap) {
		this.factor = factor;
		this.rm2IdxMap = rm2IdxMap;
	}

	public void add(String level, String repeatedMeasureValue) {
		BitSet bitSet = level2MeasureMap.get(level);
		if (bitSet == null) {
			bitSet = new BitSet(rm2IdxMap.size());
			level2MeasureMap.put(level, bitSet);
		}
		Integer rmIdx = rm2IdxMap.get(repeatedMeasureValue);
		Assertion.assertNotNull(rmIdx);
		if (!bitSet.get(rmIdx.intValue())) {
			bitSet.set(rmIdx.intValue());
		} else {
			violatingLevelSet.add(level);
		}
	}

	public boolean hasAnyViolations() {
		return !violatingLevelSet.isEmpty();
	}

	public boolean isARepeatedMeasureFactor() {
		BitSet andSet = new BitSet(rm2IdxMap.size());
		andSet.set(0, rm2IdxMap.size());
		for (BitSet bs : level2MeasureMap.values()) {
			andSet.and(bs);
		}
		return (andSet.nextSetBit(0) != -1);
	}

	public Factor getFactor() {
		return factor;
	}

	/**
	 * check if all subjects have at least one level assigned
	 * @return
	 */
	public boolean hasAllSubjectsCovered() {
		for(Integer idx : rm2IdxMap.values()) {
			boolean found = false;
			for (BitSet bs : level2MeasureMap.values()) {
				found |= bs.get(idx.intValue());
				if (found) {
					break;
				}
			}
			if (!found) {
				return false;
			}
		}
		return true;
	}
}// ;