package clinical.web.vo;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.common.query.BinaryOperator;
import clinical.web.common.query.JobProvQueryPartInfo;
import clinical.web.common.query.Operator;
import clinical.web.common.query.QueryUtils;
import clinical.web.common.query.SearchPredicate;
import clinical.web.common.query.UnaryOperator;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class JobProvenanceQueryInfo {
	private List<JobProvQueryPartInfo> qpiList;

	public JobProvenanceQueryInfo() {
	}

	public JobProvenanceQueryInfo(JobProvenanceQueryInfo other) {
		qpiList = new ArrayList<JobProvQueryPartInfo>(other.qpiList.size());
		for (JobProvQueryPartInfo qp : other.qpiList) {
			qpiList.add(new JobProvQueryPartInfo(qp));
		}
	}
	
	public int getQueryPartSize() {
		return qpiList != null ? qpiList.size() : 0;
	}

	public Operator prepareOpTree() {
		Operator root = null;
		BinaryOperator last = null;
		int noQParts = qpiList.size();
		boolean first = true;
		for (Iterator<JobProvQueryPartInfo> it = qpiList.iterator(); it
				.hasNext();) {
			JobProvQueryPartInfo qp = it.next();
			String connector = qp.getConnector();
			SearchPredicate.Range range = null;
			SearchPredicate sp = null;
			SearchPredicate.DateRange dateRange = null;

			int logOp = qp.getOperator();
			int spType = QueryUtils.getSearchPredicateType(qp.getParamType());
			if (qp.getLowBound() != null && qp.getLowBound().length() > 0
					&& qp.getUppBound() != null
					&& qp.getUppBound().length() > 0) {
				Object v = QueryUtils.convertToType(qp.getLowBound(), spType);
				if (v instanceof Date) {
					Date lowBound = (Date) v;
					Date uppBound = (Date) QueryUtils.convertToType(
							qp.getUppBound(), spType);
					dateRange = new SearchPredicate.DateRange(lowBound,
							uppBound);
				} else {
					Number lowBound = (Number) QueryUtils.convertToType(
							qp.getLowBound(), spType);
					Number uppBound = (Number) QueryUtils.convertToType(
							qp.getUppBound(), spType);

					range = new SearchPredicate.Range(lowBound, uppBound);
				}
			}
			Object value = null;
			if (range == null && dateRange == null) {
				if (qp.getRhs().trim().equals("*")) {
					value = qp.getRhs().trim();
				} else {
					value = QueryUtils.convertToType(qp.getRhs(), spType);
				}
			}
			Object attribute = qp.getParamInfo();
			if (range != null) {
				sp = new SearchPredicate(attribute, range, logOp, spType);
			} else if (dateRange != null) {
				sp = new SearchPredicate(attribute, dateRange, logOp, spType);
			} else {
				sp = new SearchPredicate(attribute, value, logOp, spType);
			}
			if (noQParts == 1) {
				root = new UnaryOperator(sp, Operator.NONE);
			} else {
				if (first) {
					UnaryOperator uo = new UnaryOperator(sp, Operator.NONE);
					root = new BinaryOperator();
					((BinaryOperator) root).setLhs(uo);
					last = (BinaryOperator) root;
					first = false;
				} else {
					// do we have more query parts?
					if (it.hasNext()) {
						last.setLogicalOp(getSelectedConnector(connector));
						BinaryOperator bop = new BinaryOperator();
						UnaryOperator lhs = new UnaryOperator(sp, Operator.NONE);
						bop.setLhs(lhs);
						last.setRhs(bop);
						last = bop;
					} else {
						// the last one
						UnaryOperator uo = new UnaryOperator(sp, Operator.NONE);
						last.setLogicalOp(getSelectedConnector(connector));
						last.setRhs(uo);
					}
				}
			}
		} // for
		return root;
	}

	public boolean hasQueryParts() {
		return qpiList != null && !qpiList.isEmpty();
	}

	protected static int getSelectedConnector(String connector) {
		return (connector.equals("AND")) ? Operator.AND : Operator.OR;
	}

	public List<JobProvQueryPartInfo> getQpiList() {
		return qpiList;
	}

	public void setQpiList(List<JobProvQueryPartInfo> qpiList) {
		this.qpiList = qpiList;
	}

	public static JobProvenanceQueryInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		JobProvenanceQueryInfo pqi = new JobProvenanceQueryInfo();
		JSONArray jsArr = js.getJSONArray("jobProvQPIList");
		pqi.qpiList = new ArrayList<JobProvQueryPartInfo>(jsArr.length());
		for (int i = 0; i < jsArr.length(); i++) {
			JSONObject json = jsArr.getJSONObject(i);
			JobProvQueryPartInfo qpi = JobProvQueryPartInfo
					.initializeFromJSON(json);
			pqi.qpiList.add(qpi);
		}
		return pqi;
	}

	@Override
	public String toString() {
		return "JobProvenanceQueryInfo [qpiList=" + qpiList + "]";
	}

}
