package clinical.web.vo;

import java.io.Serializable;
import java.util.Date;

import clinical.web.vo.JobResultTypeInfo.ResultType;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class JobResultValueSummary implements Serializable {
	private static final long serialVersionUID = 1L;
	private String name;
	private String value;
	private String subjectID;
	private Integer experimentID;
	private Integer visitID;
	/** job result group id */
	private Integer groupID;
	private ResultType resultType;
	private Date modTime;

	public String getKey() {
		StringBuilder sb = new StringBuilder();
		sb.append(subjectID).append(':');
		sb.append(experimentID).append(':').append(visitID).append(':');
		sb.append(groupID);
		return sb.toString();
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getSubjectID() {
		return subjectID;
	}

	public void setSubjectID(String subjectID) {
		this.subjectID = subjectID;
	}

	public ResultType getResultType() {
		return resultType;
	}

	public void setResultType(ResultType resultType) {
		this.resultType = resultType;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getExperimentID() {
		return experimentID;
	}

	public void setExperimentID(Integer experimentID) {
		this.experimentID = experimentID;
	}

	public Integer getVisitID() {
		return visitID;
	}

	public void setVisitID(Integer visitID) {
		this.visitID = visitID;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((experimentID == null) ? 0 : experimentID.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime * result
				+ ((subjectID == null) ? 0 : subjectID.hashCode());
		result = prime * result + ((visitID == null) ? 0 : visitID.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		JobResultValueSummary other = (JobResultValueSummary) obj;
		if (experimentID == null) {
			if (other.experimentID != null)
				return false;
		} else if (!experimentID.equals(other.experimentID))
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		if (subjectID == null) {
			if (other.subjectID != null)
				return false;
		} else if (!subjectID.equals(other.subjectID))
			return false;
		if (visitID == null) {
			if (other.visitID != null)
				return false;
		} else if (!visitID.equals(other.visitID))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("JobResultValueSummary::[");
		sb.append("subjectID:").append(subjectID);
		sb.append(",name:").append(name);
		sb.append(",value:").append(value);
		sb.append(",experimentID:").append(experimentID);
		sb.append(",visitID:").append(visitID);

		sb.append(']');
		return sb.toString();
	}

	public Integer getGroupID() {
		return groupID;
	}

	public void setGroupID(Integer groupID) {
		this.groupID = groupID;
	}

	public Date getModTime() {
		return modTime;
	}

	public void setModTime(Date modTime) {
		this.modTime = modTime;
	}
}
