package clinical.web.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Represents an assessment score value for a particular subject for a
 * particular assessment.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubjectAsScoreValueSummary.java,v 1.13 2007/04/12 19:40:06
 *          bozyurt Exp $
 */

public class SubjectAsScoreValueSummary implements Serializable {
	private static final long serialVersionUID = 9136187158740569677L;
	private String subjectID;
	private Object value;
	/** for multi-values scores */
	private ArrayList<Object> values;
	private boolean multiValued = false;
	private String scoreName;
	private String assessmentID;
	private int visitID;
	private int segmentID;
	private int experimentID;
	/** represents the clinical site database from which this object's data comes */
	private String siteID;
	private String timeStamp;
	// optional
	private String scoreType;
	private String siteName;
	private boolean remote;

	public SubjectAsScoreValueSummary() {
	}

	public void addValue(int idx, Object value) {
		if (values == null) {
			values = new ArrayList<Object>(1);
		}
		if (idx < values.size()) {
			values.set(idx, value);
		} else {
			ArrayList<Object> tempArr = new ArrayList<Object>(idx + 3);
			tempArr.addAll(values);
			for (int i = 0; i < idx - values.size(); i++) {
				tempArr.add(null);
			}
			tempArr.add(value);
			values = tempArr;
		}
	}

	public int hashCode() {
		StringBuilder buf = new StringBuilder();
		buf.append(subjectID).append('_').append(visitID).append('_').append(
				segmentID);
		buf.append('_').append(experimentID);
		return buf.toString().hashCode();
	}

	public boolean equals(Object other) {
		if (other == null)
			return false;
		if (other == this)
			return true;
		if (!(other instanceof SubjectAsScoreValueSummary)) {
			return false;
		}
		SubjectAsScoreValueSummary that = (SubjectAsScoreValueSummary) other;
		if ((subjectID != null && that.subjectID != null && subjectID
				.equals(that.subjectID))
				&& visitID == that.visitID
				&& segmentID == that.segmentID
				&& experimentID == that.experimentID) {
			return true;
		}
		return false;
	}

	// ---------------------- setters --------------
	public void setSubjectID(String newSubjectID) {
		this.subjectID = newSubjectID;
	}

	public void setValue(Object newValue) {
		this.value = newValue;
	}

	public void setScoreName(String newScoreName) {
		this.scoreName = newScoreName;
	}

	public void setAssessmentID(String newAssessmentID) {
		this.assessmentID = newAssessmentID;
	}

	public void setVisitID(int newVisitID) {
		this.visitID = newVisitID;
	}

	public void setSegmentID(int newSegmentID) {
		this.segmentID = newSegmentID;
	}

	public void setExperimentID(int newExperimentID) {
		this.experimentID = newExperimentID;
	}

	public void setSiteID(String newSiteID) {
		this.siteID = newSiteID;
	}

	public void setMultiValued(boolean newMultiValued) {
		this.multiValued = newMultiValued;
	}

	public void setTimeStamp(String newTimeStamp) {
		this.timeStamp = newTimeStamp;
	}

	// ---------------------- getters --------------
	public String getSubjectID() {
		return this.subjectID;
	}

	public Object getValue() {
		return this.value;
	}

	public String getScoreName() {
		return this.scoreName;
	}

	public String getAssessmentID() {
		return this.assessmentID;
	}

	public int getVisitID() {
		return this.visitID;
	}

	public int getSegmentID() {
		return this.segmentID;
	}

	public int getExperimentID() {
		return this.experimentID;
	}

	public String getSiteID() {
		return this.siteID;
	}

	public boolean isMultiValued() {
		return this.multiValued;
	}

	public String getTimeStamp() {
		return this.timeStamp;
	}

	public List<Object> getValues() {
		return this.values;
	}

	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append("SubjectAsScoreValueSummary::[").append("subjectID=")
				.append(subjectID);
		buf.append(",value=").append(value).append(",scoreName=").append(
				scoreName);
		buf.append(",assessmentID=").append(assessmentID);
		buf.append(",visitID=").append(visitID).append(",segmentID=").append(
				segmentID);
		buf.append(",experimentID=").append(experimentID);
		buf.append(",siteID=").append(siteID);
		buf.append(",remote=").append(remote);
		if (multiValued) {
			buf.append(",values [");
			for (Iterator<Object> iter = values.iterator(); iter.hasNext();) {
				Object value = iter.next();
				buf.append(value);
				if (iter.hasNext())
					buf.append(',');
			}
			buf.append(']');
		}
		buf.append(']');
		return buf.toString();
	}

	public String getScoreType() {
		return scoreType;
	}

	public void setScoreType(String scoreType) {
		this.scoreType = scoreType;
	}

	public String getSiteName() {
		return siteName;
	}

	public void setSiteName(String siteName) {
		this.siteName = siteName;
	}

	public boolean isRemote() {
		return remote;
	}

	public void setRemote(boolean remote) {
		this.remote = remote;
	}

}
