package clinical.web.vo.upload;

import java.io.Serializable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: RGInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class RGInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	String name;
	String descr;
	
	public RGInfo(String name, String descr) {
		this.name = name;
		this.descr = descr;
	}

	public String getName() {
		return name;
	}

	public String getDescr() {
		return descr;
	}
	
	
	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("name", name);
		js.put("descr", descr);
		return js;
	}
	
	public static RGInfo initializeFromJSON(JSONObject js)  throws JSONException {
		String name =  js.getString("name");
		String descr = js.getString("descr");
		RGInfo rgi = new RGInfo(name, descr);
		return rgi;
	}
}