package clinical.web.workflow.cbf.group;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import clinical.web.workflow.cbf.AFNIBrik;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class ROIProcessInfo implements Serializable{
	private static final long serialVersionUID = 1L;
	private File outCSVFile;
	File inputCSVFile;
	File roiMatFile;
	List<AFNIBrik> maskBriks = new ArrayList<AFNIBrik>();
	private File tableCSVFile;
	private File reportFile;
	private List<File> resultImages = new ArrayList<File>(10);
	
	public ROIProcessInfo(File inputCSVFile, File outCSVFile, File roiMatFile) {
		this.inputCSVFile = inputCSVFile;
		this.outCSVFile = outCSVFile;
		this.roiMatFile = roiMatFile;
	}
	
	public void addMaskBrik(AFNIBrik maskBrik) {
		maskBriks.add(maskBrik);
	}

	public File getOutCSVFile() {
		return outCSVFile;
	}

	public File getInputCSVFile() {
		return inputCSVFile;
	}

	public List<AFNIBrik> getMaskBriks() {
		return maskBriks;
	}

	public File getRoiMatFile() {
		return roiMatFile;
	}

	public File getTableCSVFile() {
		return tableCSVFile;
	}

	public void setTableCSVFile(File tableCSVFile) {
		this.tableCSVFile = tableCSVFile;
	}
	
	public void addResultImageFile(File imgFile) {
		this.resultImages.add(imgFile);
	}

	public List<File> getResultImages() {
		return resultImages;
	}

	public File getReportFile() {
		return reportFile;
	}

	public void setReportFile(File reportFile) {
		this.reportFile = reportFile;
	}
}
