package clinical.web.workflow.cbf.group;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import clinical.web.workflow.cbf.AFNIBrik;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class SSGAProcessInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	private File outCSVFile;
	private File inputCSVFile;
	private File assessmentCSVFile;
	private List<AFNIBrik> resultBriks = new ArrayList<AFNIBrik>(10);
	private List<File> resultFiles = new ArrayList<File>(5);
	private List<AFNIBrik> intermediateTLRCBriks = new ArrayList<AFNIBrik>();
	
	public SSGAProcessInfo(File inputCSVFile, File outCSVFile,
			File assessmentCSVFile) {
		super();
		this.inputCSVFile = inputCSVFile;
		this.outCSVFile = outCSVFile;
		this.assessmentCSVFile = assessmentCSVFile;
	}
	
	public void addResultBrik(AFNIBrik brik) {
		resultBriks.add(brik);
	}

	public File getOutCSVFile() {
		return outCSVFile;
	}

	public File getInputCSVFile() {
		return inputCSVFile;
	}

	public File getAssessmentCSVFile() {
		return assessmentCSVFile;
	}

	public List<AFNIBrik> getResultBriks() {
		return resultBriks;
	}

	public List<File> getResultFiles() {
		return resultFiles;
	}
	
	public  void addResultFile(File file) {
		resultFiles.add(file);
	}
	
	public void addIntermediateTLRCBrik(AFNIBrik brik) {
		this.intermediateTLRCBriks.add(brik);
	}

	public List<AFNIBrik> getIntermediateTLRCBriks() {
		return intermediateTLRCBriks;
	}
}
