package clinical.web.workflow.cbf.remote;

import java.text.ParseException;

import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.workflow.cbf.CBFWFContext;

/**
 * CBFWFContext and jobId info for distributed processing of a CBF workflow.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CBFWFContextWrapper.java 477 2011-11-07 22:28:33Z bozyurt $
 */
public class CBFWFContextWrapper {
	private CBFWFContext ctx;
	private String jobId;

	public CBFWFContextWrapper(CBFWFContext ctx, String jobId) {
		this.ctx = ctx;
		this.jobId = jobId;
	}

	public CBFWFContext getCtx() {
		return ctx;
	}

	public String getJobId() {
		return jobId;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		JSONObject ctxJS = ctx.toJSON();
		js.put("ctx", ctxJS);
		js.put("jobId", jobId);
		return js;
	}

	public static CBFWFContextWrapper fromJSON(JSONObject js)
			throws JSONException, ParseException {
		JSONObject ctxJS = js.getJSONObject("ctx");
		CBFWFContext ctx = CBFWFContext.fromJSON(ctxJS);
		String jobId = js.getString("jobId");
		CBFWFContextWrapper wrapper = new CBFWFContextWrapper(ctx, jobId);
		return wrapper;
	}

}
