package clinical.web.workflow.common;

import java.io.File;
import java.io.IOException;
import java.util.List;

import clinical.utils.Assertion;
import clinical.utils.CSVParser;
import clinical.web.ServiceFactory;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;
import clinical.web.exception.BaseException;

public class WFGenUtils {

	public static String extractRootDir(String datauri, String subjectID) {
		String[] parts = datauri.split("\\/+");
		int idx = -1;
		for (int i = 0; i < parts.length; i++) {
			if (parts[i].equals(subjectID)) {
				idx = i - 1;
			}
		}
		Assertion.assertTrue(idx > 0);
		int lidx = datauri.indexOf(parts[idx]);
		String srcRoot = datauri.substring(0, lidx);
		srcRoot = srcRoot.replaceFirst("\\/+$", "");
		return srcRoot;
	}

	public static User getUserWithEmail(UserInfo ui, String dbID)
			throws BaseException {
		DBConfig dbConfig = ServiceFactory.getSecurityAdminService()
				.getDBConfigMap().get(dbID);
		User user = dbConfig.findUser(ui.getName());

		if (user.getEmail() == null) {
			ISecurityService secService = ServiceFactory.getSecurityService();
			String email = secService.getEmail(ui.getName());
			user.setEmail(email);
		}
		return user;
	}

	public static List<List<String>> loadCSV(File csvFile) throws IOException {
		CSVParser csvParser = new CSVParser();
		csvParser.extractData(csvFile.getAbsolutePath());
		return csvParser.getRows();
	}

	public static String replaceCommas(String value, String delim) {
		if (value == null)
			return null;
		int idx = value.indexOf(',');
		if (idx == -1) {
			return value;
		}
		return value.replaceAll(",", delim);

	}
}
