package clinical.web.workflow.dti;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.vo.upload.VisitInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DTIWFContext.java 750 2012-12-03 20:45:56Z bozyurt $
 */
public class DTIWFContext implements Serializable {
	private static final long serialVersionUID = 1L;
	private String dbID;
	private String cacheDir;
	private List<VisitInfo> viList = new ArrayList<VisitInfo>(1);
	private String emailTo;
	private String templateDir;

	public DTIWFContext(String dbID, String cacheDir, List<VisitInfo> viList) {
		this.dbID = dbID;
		this.cacheDir = cacheDir;
		this.viList = viList;
	}

	public String getEmailTo() {
		return emailTo;
	}

	public void setEmailTo(String emailTo) {
		this.emailTo = emailTo;
	}

	public String getDbID() {
		return dbID;
	}

	public String getCacheDir() {
		return cacheDir;
	}

	public List<VisitInfo> getViList() {
		return viList;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("dbID", dbID);
		js.put("cacheDir", cacheDir);
		JSONArray jsArr = new JSONArray();
		for (VisitInfo vi : viList) {
			jsArr.put(vi.toJSON());
		}
		js.put("viList", jsArr);
		if (emailTo != null) {
			js.put("emailTo", emailTo);
		}

		return js;
	}

	public static DTIWFContext fromJSON(JSONObject js) throws JSONException,
			ParseException {
		List<VisitInfo> viList = new ArrayList<VisitInfo>(1);
		String dbID = js.getString("dbID");
		String cacheDir = js.getString("cacheDir");
		JSONArray jsArr = js.getJSONArray("viList");
		for (int i = 0; i < jsArr.length(); i++) {
			JSONObject jo = jsArr.getJSONObject(i);
			viList.add(VisitInfo.initializeFromJSON(jo));
		}
		DTIWFContext ctx = new DTIWFContext(dbID, cacheDir, viList);

		if (js.has("emailTo")) {
			ctx.emailTo = js.getString("emailTo");
		}
		return ctx;
	}

	public String getTemplateDir() {
		return templateDir;
	}

	public void setTemplateDir(String templateDir) {
		this.templateDir = templateDir;
	}
}
