package clinical.web.workflow.dti;

import java.io.File;
import java.util.Properties;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;

import clinical.utils.Executor;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DTIWFProxy.java 750 2012-12-03 20:45:56Z bozyurt $
 */
@SuppressWarnings("unused")
public class DTIWFProxy {
	boolean verbose = false;
	int port = 80;
	boolean useHTTPS = false;
	String host;
	Properties properties;
	private boolean canceled = false;

	public DTIWFProxy(Properties properties) {
		this.properties = properties;
	}

	public synchronized void cancel() {
		this.canceled = false;
	}
	
	public void sendData(DTIVisitProcessInfo dvpi, String targetHost)
			throws Exception {
		// create the remote directory structure

		// copy the raw data
		for (DTIProcessInfo dpi : dvpi.getDpiList()) {
			File fm1DicomDir = new File(dpi.getFieldMap1SI().getShi()
					.getImages().get(0));
			File fm2DicomDir = new File(dpi.getFieldMap2SI().getShi()
					.getImages().get(0));

			File dtiDir = new File(dpi.getDtiSI().getShi().getImages().get(0));
			// TODO
		}
	}

	public boolean notifyDataAvailability(String visitDTIDataDir,
			String targetURL) throws Exception {
		GetMethod getMethod = new GetMethod(targetURL);
		NameValuePair[] nvArr = new NameValuePair[1];
		nvArr[0] = new NameValuePair("dtiLoc", visitDTIDataDir);
		getMethod.setQueryString(nvArr);
		try {
			HttpClient client = new HttpClient();
			client.getHttpConnectionManager().getParams().setConnectionTimeout(
					5000);
			if (verbose) {
				System.out.println("connecting to the server");
			}
			int status = client.executeMethod(getMethod);
			if (status == HttpStatus.SC_OK) {
				String responseStr = getMethod.getResponseBodyAsString();
				System.out.println("response:" + responseStr);
				return true;
			} else {
				throw new Exception(
						"problem in notifying the DTI processing system from server "
								+ "\nHTTP Status: " + status);
			}
		} finally {
			getMethod.releaseConnection();
		}
	}

	public String pollForDTIProcessingResults(String visitDTIDataDir,
			String targetURL) throws Exception {
		GetMethod getMethod = new GetMethod(targetURL);
		NameValuePair[] nvArr = new NameValuePair[1];
		nvArr[0] = new NameValuePair("dtiLoc", visitDTIDataDir);
		getMethod.setQueryString(nvArr);
		try {
			HttpClient client = new HttpClient();
			client.getHttpConnectionManager().getParams().setConnectionTimeout(
					5000);
			int status = client.executeMethod(getMethod);
			if (status == HttpStatus.SC_OK) {
				String responseStr = getMethod.getResponseBodyAsString();
				return responseStr;
			} else {
				throw new Exception(
						"problem polling for DTI processing results availability."
								+ "\nHTTP Status: " + status);
			}
		} finally {
			getMethod.releaseConnection();
		}
	}

	public static int copyFromDir(String remoteHost, String remoteDir,
			String localDestDir) throws Exception {
		Executor executor = new Executor("/usr/bin/scp", true);
		StringBuilder sb = new StringBuilder(128);
		sb.append(" -r ").append(remoteHost).append(':').append(remoteDir)
				.append(' ');
		sb.append(localDestDir);
		System.out.println("scp " + sb.toString());
		return executor.execute(sb.toString());
	}

	public static int copyDirTo(String srcDir, String targetHost,
			String targetDir) throws Exception {
		Executor executor = new Executor("/usr/bin/scp", true);
		StringBuilder sb = new StringBuilder(128);
		sb.append(" -r ").append(srcDir).append(' ');
		sb.append(targetHost).append(':').append(targetDir);
		System.out.println("scp " + sb.toString());
		return executor.execute(sb.toString());
	}

	public static int makeRemoteDirPath(String targetHost, String targetDir)
			throws Exception {
		Executor executor = new Executor("/usr/local/bin/mk_remote_path", true);
		StringBuilder sb = new StringBuilder(128);
		sb.append(targetHost).append(" ").append(targetDir);
		System.out.println("ssh " + sb.toString());
		return executor.execute(sb.toString());
	}

	static void testSSH() throws Exception {
		String targetHost = "bozyurt@csf.ucsd.edu";
		String targetDir = "exp/subject/visit";
		String srcDir = "/home/bozyurt/dti_test/dti";

		int rc = makeRemoteDirPath(targetHost, targetDir);
		System.out.println("rc=" + rc);

		rc = copyDirTo(srcDir, targetHost, targetDir);
		System.out.println("rc=" + rc);
	}

	public static void main(String[] args) throws Exception {

		testSSH();
	}
}
