<%@ page contentType="text/html;charset=UTF-8" language="java"%>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean"%>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html"%>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core"%>


<script type="text/javascript"
	src="<%=request.getContextPath()%>/pages/yui/yahoo-dom-event/yahoo-dom-event.js"></script>
<script type="text/javascript"
	src="<%=request.getContextPath()%>/pages/yui/element/element-min.js"></script>
<script language='javascript'
	src='<%=request.getContextPath()%>/pages/validator.js'></script>

<script language='javascript'
	src='<%=request.getContextPath()%>/pages/logging.js'></script>
<script language='javascript'>
  var logger = null;
  var exp2ViListMap = null;

  function prepLogger() {
     logger = new Console("console");
     logger.append("initialized logger");
  }
  
  function onLoadHandler() {
      // prepLogger(); 
	  exp2ViListMap = <c:out value="${batchForm.exp2ViListJSON}" escapeXml="false" />;
	  handleViListPopulation();
     var url = '<html:rewrite page="/help.do?context=workflow"/>';
     var helpSystem = new bal.AjaxHelpSystem(url, {width:450});
     helpSystem.registerButton('help_24');
     helpSystem.registerButton('help_25');
     helpSystem.registerButton('help_26');
     helpSystem.registerButton('help_27');
  }

  function handleViListPopulation() {
	  var expSelector = document.getElementById('expSelector'), 
        option, i;
	  if (!expSelector) return;
	  var viSelector = document.getElementById('viSelector');
	  var selExpId = expSelector.options[ expSelector.selectedIndex].value; 
	  var vilInfo = exp2ViListMap[selExpId];
	  if (!vilInfo) return;
	  var viList = vilInfo.viList;
	  viSelector.options.length = 0;
	  for(i = 0; i < viList.length; i++) {
		  option = new Option( viList[i].label, viList[i].id);
		  try {
			  viSelector.add(option,null);
		  } catch(e) {
			  viSelector.add(option,-1);
		  }
	  }
	  jQuery("#reg_rb")[0].disabled=true;
	  jQuery("#acs_cb")[0].disabled=true;
	  jQuery("#pvc_rb")[0].disabled=true;
	  onVisitChange(viSelector);
  }

  function validate() {
	  var viSelector = document.getElementById('viSelector');
	  if (!viSelector) return false;
	  var count = 0, i;
	  for(i = 0; i < viSelector.options.length; i++) {
		  if (viSelector.options[i].selected) {
			  count++;
		  }
	  }
	  if (count === 0) {
		  alert("At least a series needs to be selected for job submission!");
		  return false;
	  }
	  return true;
  }

  function onVisitChange(selector) {
	  var expSelector = document.getElementById('expSelector');
	  var selExpId = expSelector.options[ expSelector.selectedIndex].value; 
	  var vilInfo = exp2ViListMap[selExpId];
     var len, selViList, i, vi;
	  if (!vilInfo) return;
	  var viList = vilInfo.viList;
	  if (selector.selectedIndex == -1) return;
	  // if (logger != null) logger.append("vi selected:" + selector.selectedIndex);
	  selViList = [];
	  len = selector.options.length;
	  for(i = 0; i < len; i++) {
		  if (selector.options[i].selected) 
			selViList.push(viList[i]);
	  }
	  var isSiemens = true;
	  var hasAnat = true;
	  var hasFM = true;
	  len = selViList.length;
	  for(i = 0; i < len; i++) {
		  vi = selViList[i];
		  isSiemens = isSiemens && (vi.scanner && vi.scanner === "Siemens");
		  hasFM = hasFM && vi.hasFM;
		  hasAnat = hasAnat && vi.hasAnat;
		  if (!hasAnat && !isSiemens) break;
	  }   	  
      jQuery('#lt_cb')[0].checked = false;
      if (isSiemens) {
          jQuery("#sense_rb")[0].disabled=true;
          jQuery("#acs_cb")[0].disabled=false;
          jQuery("#pvc_rb")[0].disabled=false;
      } else {
        jQuery("#sense_rb")[0].disabled=false;
     	  if (hasAnat) {
         	 jQuery("#acs_cb")[0].disabled=false;
         	 jQuery("#acs_cb")[0].checked=false;
         	 jQuery("#pvc_rb")[0].disabled=false;
     	  } else {
     		 jQuery("#acs_cb")[0].checked=false;
          jQuery("#acs_cb")[0].disabled=true;
     		 jQuery("#pvc_rb")[0].disabled=true;
     	  }
     	 if (hasFM) {
     		    jQuery("#fmc_rb")[0].disabled=false;
     	  } else {
         	 jQuery("#fmc_rb")[0].checked=false; 	  
     	  }
      }   
  }

 	  
  YAHOO.util.Event.onDOMReady(function() {
     var Dom = YAHOO.util.Dom, Event = YAHOO.util.Event;

     jQuery("#reg_rb")[0].disabled=true;
     jQuery("#acs_cb")[0].disabled=true;
     jQuery("#pvc_rb")[0].disabled=true;

     Event.on("acs_cb","click", function(ev) {
         if (jQuery("#acs_cb")[0].checked) {
    	     jQuery("#pvc_rb")[0].disabled=false;
         } else {
        	  jQuery$("#pvc_rb")[0].disabled=true;
         }
     });
     Event.on("fmc_rb", "click" , function(ev) {
         jQuery("#reg_rb")[0].disabled=false;
     });
     Event.on("def_rb", "click", function(ev) {  
            jQuery("#reg_rb")[0].disabled=true; });
     Event.on("sense_rb", "click", function(ev) {  
         jQuery("#reg_rb")[0].disabled=true; });

    Event.on("lt_cb", "click", function(ev) {
       var auto_cb$ = jQuery('#acs_cb');
       auto_cb$.prop("disabled",jQuery(this).prop("checked"));
    });
    
	 Event.on("bcjf", "submit", function(ev) {
		  var ok = validateIfSiemensAppropriate();
		  if (!ok || !validateThresh() || !validateFWHM() ) {
			  Event.preventDefault(ev);
		  } 
	  });
	 Event.on("viSelector","change", function(ev) { 
       onVisitChange(jQuery("#viSelector")[0]); });
	 Event.on("expSelector","change", function(ev) { handleViListPopulation(); });
	 
     onLoadHandler();
     var validateThresh = function() {
          var field = Dom.get('gmt');
			 if (field.value.length === 0) {
			    alert("A gray matter threshold value needs to be specified!");
				 return false;
			 }
			 if (!clinical.isNumber(field.value) ) {
			    alert("Gray matter threshold must be a number!");
				 return false;
			} else {
			  if (field.value < 0.5 || field.value > 1.0) {
			    alert("Gray matter threshold value must in in range [0.5-1.0]!");
				 return false;
			  }
			}
         return true;  
     };

     var validateIfSiemensAppropriate = function() {
   	  var expSelector = jQuery('#expSelector')[0];
   	  var selExpId = expSelector.options[ expSelector.selectedIndex].value; 
   	  var vilInfo = exp2ViListMap[selExpId];
   	  if (!vilInfo) return true;
   	  var viList = vilInfo.viList;
   	  var selector = jQuery("viSelector")[0];
   	  if (!selector) return true;
         var vi = viList[selector.selectedIndex];
         
         if (vi.scanner && vi.scanner === "Siemens") {
          // Siemens manual segmentation support 5/29/2012
          /*   
           if (jQuery("#acs_cb")[0].checked == false) {
       		  alert("For Siemens, only automatic CBF segmentation is supported!");
       		  return false;
       	   }
          */	  
         }
         return true;
     };
  });

   var validateFWHM = function() {
    	 var field = Dom.get('fwhm');
		 if (field.value.length == 0) {
              field.value = 0;
		 } else {
			 if (!clinical.isNumber(field.value) ) {
                  alert("Smoothing parameter must be a real number!");
                  return false;   
			 } else {
				 if (field.value < 0 || field.value > 10.0) {
					 alert("Smoothing parameter value must in in range [0 - 10.0]!");
				     return false;
				 }
			 }
		 } 
		 return true;
   };
  

</script>

<div class="error"><html:errors /></div>

<html:form action="/batchcbfjobman" styleId="bcjf">
	<input type="hidden" name="action" value="submitJobs" />

	<div id="jobManPane" class="mainPanel">
	<div class="headerPane">
	<div class="mlarge" style="margin: 0 0 0 5px; padding: 0;">Batch CBF
	Job Submission</div>
	</div>
	<c:if test="${batchForm.hasData == true}">
		<div class="input_div">
         <label><span class="label"
			   title="Name of the project/experiment">Experiment:</span></label> 
       <bean:define id="expList" name="batchForm" 
            property="expSelector.experimentInfos" type="java.util.Collection" /> 
      <html:select styleId="expSelector"
			name="batchForm" property="expSelector.selectedExpID"
			onchange="handleViListPopulation();">
			<html:options collection="expList" property="value"
				labelProperty="label" />
		</html:select>
      </div>
		<div class="input_div"><label><span class="label"
			title="Series for processing (Subject ID  Visit Date)">Series:</span></label>
		<select id="viSelector" name="viSelector" size="8" multiple="multiple"></select>

      </div>
		<div class="input_div">
         <div><span style="font-weight: bold">Preprocessing </span><span id="help_24"></span></div>
		</div>
		<div class="input_div"><c:if
			test="${not batchForm.doFieldMapCorrection and not batchForm.doSense }">
			<input id="def_rb" type="radio" name="preproc" value="default"
				checked>
		</c:if> <c:if test="${batchForm.doFieldMapCorrection or batchForm.doSense }">
			<input id="def_rb" type="radio" name="preproc" value="default">
		</c:if> No Correction</div>
		<div class="input_div"><c:if
			test="${batchForm.doFieldMapCorrection}">
			<input id="fmc_rb" type="radio" name="preproc"
				value="doFieldMapCorrection" checked>
		</c:if> <c:if test="${not batchForm.doFieldMapCorrection}">
			<input id="fmc_rb" type="radio" name="preproc"
				value="doFieldMapCorrection" />
		</c:if> Field Map Correction
		<div id="fmc" style="margin-left: 2em; padding: 5px;">
		Registration <c:if test="${batchForm.doReg}">
			<input id="reg_rb" type="checkbox" name="doReg" checked>
		</c:if> <c:if test="${not batchForm.doReg}">
			<input id="reg_rb" type="checkbox" name="doReg" />
		</c:if></div>
		</div>
		<div class="input_div"><c:if test="${batchForm.doSense}">
			<input id="sense_rb" type="radio" name="preproc" value="doSense"
				checked>
		</c:if> <c:if test="${not batchForm.doSense}">
			<input id="sense_rb" type="radio" name="preproc" value="doSense">
		</c:if> SENSE</div>

     <div class="input_div">
        <div> <span style="font-weight: bold">CBF Calibration </span><span id="help_25"></span></div>
        <div class="input_div">Automatic CSF Segmentation 
           <c:if test="${batchForm.useAutomatedSegmentation}">
           <input id="acs_cb" type="checkbox" name="doAutoCSF" checked>
           </c:if> 
           <c:if test="${not batchForm.useAutomatedSegmentation}">
           <input id="acs_cb" type="checkbox" name="doAutoCSF" />
           </c:if>
        </div>

        <div class="input_div">
           CSF Method: &nbsp;
           <c:if test="${batchForm.csfMethod == 2}">
           <input id="csfm_rb" type="radio" name="csfMethod" value="2" checked>
           </c:if>
           <c:if test="${batchForm.csfMethod != 2}">
           <input id="csfm_rb" type="radio" name="csfMethod" value="2">
           </c:if>
           Partial Volume &nbsp;
           <c:if test="${batchForm.csfMethod == 1}">
           <input id="csfm_rb" type="radio" name="csfMethod" value="1" checked>
           </c:if>
           <c:if test="${batchForm.csfMethod != 1}">
           <input id="csfm_rb" type="radio" name="csfMethod" value="1">
           </c:if>
           Top 5 &nbsp;
          <c:if test="${batchForm.csfMethod == 0}">
			   <input id="csfm_rb" type="radio" name="csfMethod" value="0" checked>
          </c:if>
          <c:if test="${batchForm.csfMethod != 0}">
			   <input id="csfm_rb" type="radio" name="csfMethod" value="0">
          </c:if>
          Automatic
        </div>
		   <div class="input_div" id="lt">
		      Local Tissue Method
		      <c:if test="${batchForm.useLTMethod}">
			      <input id="lt_cb" type="checkbox" name="ltMethod" checked>
		      </c:if> 
		      <c:if test="${not batchForm.useLTMethod}">
			      <input id="lt_cb" type="checkbox" name="ltMethod" />
		      </c:if>
		   </div>
      </div>


     <div class="input_div">
        <div> <span style="font-weight: bold">Registration of anatomical to ASL </span><span id="help_26"></span></div>
        <div class="input_div">
        <c:if test="${batchForm.alignment == 3}">
			  <input id="align_rb" type="radio" name="align" value="3" checked>
        </c:if>
        <c:if test="${batchForm.alignment != 3}">
			  <input id="align_rb" type="radio" name="align" value="3">
        </c:if>
         Use align_epi_anat.py script and register to CSF Brik
        </div>
        <div class="input_div">
        <c:if test="${batchForm.alignment == 1}">
			  <input id="align_rb" type="radio" name="align" value="1" checked>
        </c:if>
        <c:if test="${batchForm.alignment != 1}">
			  <input id="align_rb" type="radio" name="align" value="1">
        </c:if>
         Use 3dAllineate and register to ASL Brik
        </div>
        <div class="input_div">
        <c:if test="${batchForm.alignment == 2}">
			  <input id="align_rb" type="radio" name="align" value="2" checked>
        </c:if>
        <c:if test="${batchForm.alignment != 2}">
			  <input id="align_rb" type="radio" name="align" value="2">
        </c:if>
        Use 3dAllineate and register to CSF Brik
        </div>
        <div class="input_div">
           <c:if test="${batchForm.alignment == 0}">
           <input id="align_rb" type="radio" name="align" value="0" checked>
           </c:if>
           <c:if test="${batchForm.alignment != 0}">
           <input id="align_rb" type="radio" name="align" value="0">
           </c:if>
           No Alignment
        </div>
      </div>

		<div class="input_div">
         <div><span style="font-weight: bold">Post Processing </span><span id="help_27"></span></div>
		  <div class="input_div">
           <label>Anat: Gray Matter Threshold [0.5 -1.0]:</label> 
            <html:text name="batchForm" property="gmThreshold" styleId="gmt" size="6" />
        </div>
		  <div class="input_div">Anat: Skull Stripping 
          <c:if test="${batchForm.doSkullStripping}">
			  <input type="checkbox" name="doSkullStripping" checked>
		   </c:if> 
         <c:if test="${not batchForm.doSkullStripping}">
		  	 <input type="checkbox" name="doSkullStripping" />
		   </c:if>
        </div>
		  <div class="input_div">
		    <label>CBF: Spatial Smoothing (FWHM) Parameter [0 - 10.0]:</label>
		    <html:text name="batchForm" property="gaussianFilterParam" styleId="fwhm"
			  size="6" />
		  </div>
        <div class="input_div">CBF: MPPCASL Bayesian Model Fit (fabber)
		    <c:if test="${batchForm.doFabber}">
			  <input type="checkbox" name="doFabber" checked>
		    </c:if> 
		    <c:if test="${not batchForm.doFabber}">
			  <input type="checkbox" name="doFabber" />
		    </c:if>
		  </div>
        <div id="pvc" class="input_div">CBF: Partial
           Volume Correction 
           <c:if test="${batchForm.doPartialVolumeCorrection}">
           <input id="pvc_rb" type="checkbox" name="doPVC" checked>
           </c:if> 
           <c:if test="${not batchForm.doPartialVolumeCorrection}">
           <input id="pvc_rb" type="checkbox" name="doPVC" />
           </c:if>
        </div>
		</div>
		<div class="button_div"><input type="submit"
			class="submit-button" value="Submit Job" id="viSelButton"
			onclick="return validate();" />
      </div>
	</c:if> 
   <c:if test="${not batchForm.hasData}">
		<div class="input_div"><span
			style="color: red; font-weight: bold;"> No data is available
		for CBF processing! </span></div>
	</c:if>
	</div>
</html:form>
<div id="console"></div>

<script>
     var divElem = jQuery('#jobManPane')[0];
     var options = {color: "#ffcc33", corners: 'top'};
     Rico.Corner.round( divElem, options );
     Rico.Corner.round( divElem,  {color: "#d3d3d3", corners: 'bottom'});
     var tabs = jQuery('#tabs li');
     tabs.each(
         function() { 
            Rico.Corner.round( jQuery(this)[0],  {color: "#00659c", corners: 'top'}); }
      );
</script>

