<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<link rel="stylesheet" type="text/css" href="layout/jquery-ui.css">
<link rel="stylesheet" type="text/css" href="yui/assets/skins/sam/skin.css">
<link rel="stylesheet" type="text/css" href="yui/assets/skins/sam/button.css">

<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/jquery-ui-1.10.2.js"></script>

<script type="text/javascript"
   src="<%=request.getContextPath()%>/pages/synadmin.js"></script>

<style>
 #templates {
  display:none;
 }

 #ssmPane, #synonymEntryPanel {
   margin-left: 5px;
   margin-top:5px;
   margin-bottom:5px;
 }

 #ssmPane label {
    font-weight:bold;
 }

fieldset,legend {
  /* border: 2px ridge silver; */
  border: 1px solid black;
}

fieldset {
  padding-top: 12px;
  margin-right: 5px;
}

legend {
  padding: 0.2em 0.8em;
  margin-left: 1em;
  background-color: #2d5868;
  font-weight: bold;
  color: #fff;
}

#ssListTable {
   border-collapse:collapse;
   border: 1px solid  #2d5868;
}

#ssListTable tr, #ssListTable td {
   border: 1px solid  #2d5868;
   padding:3px;
}

#ssListTable thead {
   font-weight: bold;
}

.ssListPane {
   margin:5px;
}

button.synonymRemover {
    background: url("images/delete.png") no-repeat scroll 50% 50% transparent;
    border: medium none;
    display: inline-block;
    height: 16px;
    vertical-align: middle;
    width: 16px;
}
</style>


<script>
   jQuery(function() {
      var alObj= <c:out value="${saForm.asiListJSON}" escapeXml="false" />;
      var asiList = alObj.asiList;
      alObj = null; 
      var svURL = '<html:rewrite page="/synman.do?action=scorevals"/>';
      var asExpURL = '<html:rewrite page="/synman.do?action=asexps"/>';
      var addSynURL = '<html:rewrite page="/synman.do?action=save"/>';
      var listSynURL = '<html:rewrite page="/synman.do?action=list"/>';
      var delSynURL = '<html:rewrite page="/synman.do?action=delete"/>';
      var synAdmin = new clinical.SynAdmin(asiList, svURL, asExpURL, 
        addSynURL, listSynURL, delSynURL); 
   });

</script>   
<div class="error">
    <html:errors/>
</div>

<div id="mainPane" class="mainPanel">
   <div class="headerPane">
      <div class="mlarge" style="margin:0 0 0 5px; padding:0;">Manage Score Value Synonyms</div>
   </div>
   <div id="ssmPane">
      <fieldset id="ssmPaneFS">
         <legend>Score Synonym Management</legend>
         <div style="padding-left:5px;">
              <label for="asFilter">Assessment:</label>
              <select id="asFilter" name="asFilter" class="asChooser" title="Select an assessment"></select>
              <label for="scoreFilter">Score:</label>
              <select id="scoreFilter" name="scoreFilter" class="scoreChooser" title="Select a score"></select> 
         </div>
         <div id="synonymEntryPanel" style="margin-top:5px;">
            <div>  
             <%--  
               <label for="asFilter">Experiments:</label>
               <select id="expFilter" name="expFilter" class="expChooser" multiple="true" title="Select experiment(s)"></select>
              --%>
               <label for="svFilter">Score Values:</label>
               <select id="svFilter" name="svFilter" class="svChooser" multiple="true" title="Select scores"></select>
              <label for="canonicalValue">Canonical Value:</label>
              <input type="text" name="canonicalValue" id="canonicalValue" value=""/>
           </div> 
           <div class="buttonBar">
              <button id="addSynonym" class="submit-button">Add Synonym</button>
           </div>

         </div>

      </fieldset>

    </div>
    <div class="ssListPane">
       <h3>Available Synonym Mappings</h3>
       <table id="ssListTable">
           <thead>
              <td>Score Name</td>
              <td>Assessment Name</td>
              <td>Synonyms</td>    
              <td>Canonical Value</td>
              <td>&nbsp;</td>
           </thead>   
           <tbody>
              
           </tbody>  
       </table>
    </div>
</div>


<div id="templates">
</div>

<script>
     var divElem = jQuery('#mainPane')[0];
     var options = {color: "#ffcc33", corners: 'top'};
     Rico.Corner.round( divElem, options );
     Rico.Corner.round( divElem,  {color: "#d3d3d3", corners: 'bottom'});
</script>
