var sc = {};

sc.AjaxShoppingCart = function(url, options, aLogger) {
   this.url = url;
   this.options = options;
   this.logger = aLogger || null;
   this.listeners = [];
};

sc.AjaxShoppingCart.prototype.addListener = function(listener) {
   this.listeners[this.listeners.length] = listener;
};

sc.AjaxShoppingCart.prototype.checkItemCount = function(url) {
   this.ajaxHelper = new net.ContentLoader(this, url, "POST", [] );
   this.ajaxHelper.sendRequest();
};

sc.AjaxShoppingCart.prototype.ajaxUpdate = function(request) {
  var xmlDoc = request.responseXML,
      elems = xmlDoc.getElementsByTagName('success'),
      itemCount, i, j, lsnrs, lsnr;
  if (elems && elems.length > 0) {
     // request returned with success message
     itemCount = -1;
     for(j = 0; j < elems[0].attributes.length; ++j) {
        if  (elems[0].attributes[j].nodeName === 'itemCount') {
	       itemCount = elems[0].attributes[j].nodeValue;
	    }
     }
     //alert(elems[0] + " name:" + elems[0].tagName + " itemCount:" + elems[0].itemCount + "\nAttributes: " + str);
     if ( itemCount >= 0) {
	    lsnrs = this.listeners;
	    for(i=0; i< lsnrs.length;i++) {
	       lsnr = lsnrs[i];
	       //alert('calling listener :' + lsnr + " with itemCount:" + itemCount);
	      lsnr.call(this, itemCount);
	    }
     }
  }
};

sc.AjaxShoppingCart.prototype.handleError = function(request) {
  if ( this.options && this.options.errorHandler) {
     this.options.errorHandler(request);
  }
};

sc.AjaxShoppingCart.prototype.addItem = function(requestParams) {
  this.ajaxHelper = new net.ContentLoader(this, this.url, "POST",
      requestParams || [] );
  this.ajaxHelper.sendRequest();
};
