;(function($, window, document, undefined) {
    var methods = {
       init : function(options, selections) {
          var this$ = $(this),
              data =  this$.data('ratingcomp'),
              settings = $.extend({
                       ratingControl : 'select.ratingSel',
                       reasonDiv : '#reasonDiv',
                       ratings : ['Excellent','Good','Average','Marginal','Unusable'],
                       reasons : [],
                       showReasonFor : ['Marginal','Unusable'],
                      /* collectUserReason : true, */
                       justUserReason : false 
                      }, options || {});
          var selEl$ = $(settings.ratingControl, this$);
          var reasonDiv$ = $(settings.reasonDiv, this$);
          if (!data) {
             this$.data('ratingcomp', {settings: settings});
          }

          function createReasons() {
            var cbgDiv$,i, val, str;
            if (settings.reasons.length > 0) {
               if ( $('div.reason-cbg',reasonDiv$).size() !== 0) {
                   return;
               }
               cbgDiv$ = $('<div></div>').addClass('reason-cbg');
               for(i = 0; i < settings.reasons.length; i++) { 
                    val = settings.reasons[i];
                    str = '<input type="checkbox" name="reason" value="' + 
                    val + '" id="rcb' + i + '"></input><label for="rcb' + 
                    i + '">' + val + '</label>';
                    $('<div></div>').append($(str)).appendTo(cbgDiv$);
               }
               cbgDiv$.appendTo($(settings.reasonDiv, this$));
               str = '<label for="userReason">Comments:</label><textarea id="userReason" cols="40" rows="3"></textarea>';
               $('<div></div>').attr('id','userReasonDiv').append($(str)).appendTo(cbgDiv$);
               $('#userReasonDiv',cbgDiv$).css({verticalAlign:'middle'}).
                  children().css('vertical-align','middle').end().hide();
               $(':checkbox',cbgDiv$).bind('change', function() {
                   var value = $(this).val();
                   if (value == 'Other') {
                      if (this.checked) {
                        $('#userReasonDiv',cbgDiv$).show();
                      } else {
                        $('#userReasonDiv',cbgDiv$).hide();
                      }
                   }
               });
            }
          }
          
          function createJustComments() {
        	  var cbgDiv$,i, val, str;
        	  if ( $('div.reason-cbg',reasonDiv$).size() !== 0) {
                  return;
              }
              cbgDiv$ = $('<div></div>').addClass('reason-cbg');
              cbgDiv$.appendTo($(settings.reasonDiv, this$));
              str = '<label for="userReason">Comments:</label><textarea id="userReason" cols="40" rows="3"></textarea>';
              $('<div></div>').attr('id','userReasonDiv').append($(str)).appendTo(cbgDiv$);
              $('#userReasonDiv',cbgDiv$).css({verticalAlign:'middle'}).
                 children().css('vertical-align','middle');
          }
          
          var ratings = settings.ratings;
          var ratingTitle = selEl$.attr('title');
          ratings.unshift(ratingTitle ? '-- ' + ratingTitle : '-- select a rating');
          $.populateSelect(selEl$[0],ratings, function(o) {
              return {name: o, value: o };
          });
          selEl$.bind('change', this, function(event) {
            var selVal = $(':selected',this).val();
            var found = false;
            for(var i = 0; i < settings.showReasonFor.length;i++) {
                if (selVal === settings.showReasonFor[i]) {
                   found = true;
                   break;
                }
            }
            if (found) {
            	if (settings.justUserReason) {
            		createJustComments();
            	} else {
                    createReasons();
            	}
            } else {
                $('div.reason-cbg',$(this).parent()).remove();
            }
            $('option[value^="--"]',this).remove();
          });
          
          if (selections && selections.rating) {
        	  $(selEl$).val(selections.rating).trigger('change');
        	  if (selections.reasons) {
        		 $(':checkbox',reasonDiv$).each( function() {
        			 var this$ = $(this), value = this$.val();
        			 for(var i = 0; i < selections.reasons.length; i++) {
             			if (value === selections.reasons[i]) {
             				 this$.attr('checked','checked');
             				 break;
             			}
        			 }
        		 });
        	  }
        	  if (selections.comments) {
        		  $('#userReason', reasonDiv$).val(selections.comments);
        		  $('#userReasonDiv',reasonDiv$).show();
        	  }
          }
          return this;
       },

       destroy : function() {
          var this$ = $(this), 
              data = this$.data('ratingcomp');
          this$.removeData('ratingcomp');
       },
       
       getcollected : function() {
         // JSON
    	   var startTime = new Date().getMilliseconds();  
         var $this = $(this), 
             data = $this.data('ratingcomp'),
             selEl$ = $(data.settings.ratingControl, $this),
             reasonDiv$ = $(data.settings.reasonDiv,$this),
             result = {}, errMsg = '', found = false, i,
             settings = data.settings;
         var value = selEl$.val();
         if (value.indexOf('--') === 0) {
           errMsg += 'Please select a valid rating!';
           alert(errMsg);
           return null;
         }
         result.rating = value;
         for(i = 0; i < data.settings.showReasonFor.length;i++) {
           if (value == data.settings.showReasonFor[i]) {
               found = true;
               break;
           }
         }
         var cbgDiv$ = $('div.reason-cbg',reasonDiv$);
         if ( cbgDiv$.size() !== 0) {
             result.reasons = $('[name="reason"]:checked',cbgDiv$).map(
              function() { return $(this).val(); }).toArray();
             result.userComment = $('#userReason',cbgDiv$).val(); 
             if (!result.reasons || result.reasons.length == 0) {
                if (found && !settings.justUserReason) {
                   alert("No reason is provided for the rating:'" + value + "'!");
                   return null;
                }
            }  
            var uc = $.trim(result.userComment);
            if (uc.length === 0) {
              if (settings.justUserReason) {
              	  alert("No explanation is provided for the rating!'");
                  return null;  
              }	
              for(i = 0; i < result.reasons.length; i++) {
                  if (result.reasons[i] == 'Other') {
                      alert("No explanation is provided for the rating:'" + result.reasons[i] +"'!");
                      return null;
                  }
              }
            }
         }
         var jsonResult = JSON.stringify(result);
         var diff = new Date().getMilliseconds() - startTime;
         // alert('result=' + jsonResult + " diff (msecs):" + diff);
         return jsonResult;
       }
    };
    $.fn.ratingcomp = function(method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments,1));
        } else if (typeof method === 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
           $.error('Method ' + method + ' does not exist on jquery.cbfbirn.ratingcomp!');
        }
    }
})(jQuery,window, document);
