-- 
-- TABLE: bk_tupleAccess 
--

ALTER TABLE bk_tupleAccess ADD CONSTRAINT Refnc_databaseUser2531 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE bk_tupleAccess ADD CONSTRAINT Refnc_databaseUser2541 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE bk_tupleAccess ADD CONSTRAINT Refnc_tupleAccess2581 
    FOREIGN KEY (tableID, tupleID, grantor, grantee)
    REFERENCES nc_tupleAccess(tableID, tupleID, grantor, grantee)
;


-- 
-- TABLE: nc_animalSpecies 
--

ALTER TABLE nc_animalSpecies ADD CONSTRAINT Refnc_databaseUser2321 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_animalSpecies ADD CONSTRAINT Refnc_databaseUser2331 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_animalSpecies ADD CONSTRAINT Refnc_tableID2701 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_assessment 
--

ALTER TABLE nc_assessment ADD CONSTRAINT Refnc_assessment1801 
    FOREIGN KEY (previousAssessmentID)
    REFERENCES nc_assessment(assessmentID)
;

ALTER TABLE nc_assessment ADD CONSTRAINT Refnc_tableID3641 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_assessment ADD CONSTRAINT Refnc_databaseUser3951 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessment ADD CONSTRAINT Refnc_databaseUser3961 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_assessmentBoolean 
--

ALTER TABLE nc_assessmentBoolean ADD CONSTRAINT Refnc_assessmentData821 
    FOREIGN KEY (tableID, nc_assessmentData_uniqueID)
    REFERENCES nc_assessmentData(tableID, uniqueID)
;

/* DYW, removed
ALTER TABLE nc_assessmentBoolean ADD CONSTRAINT Refnc_storedAssessment1321 
    FOREIGN KEY (storedAssessmentID, tableID)
    REFERENCES nc_storedAssessment(uniqueID, tableID)
;
*/

ALTER TABLE nc_assessmentBoolean ADD CONSTRAINT Refnc_assessmentScore1391 
    FOREIGN KEY (assessmentID, scoreName)
    REFERENCES nc_assessmentScore(assessmentID, scoreName)
;

ALTER TABLE nc_assessmentBoolean ADD CONSTRAINT Refnc_databaseUser2041 
    FOREIGN KEY (raterID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentBoolean ADD CONSTRAINT Refnc_databaseUser2051 
    FOREIGN KEY (keyerID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentBoolean ADD CONSTRAINT Refnc_dataClassification2121 
    FOREIGN KEY (nc_dataClassification_uniqueID)
    REFERENCES nc_dataClassification(uniqueID)
;

ALTER TABLE nc_assessmentBoolean ADD CONSTRAINT Refnc_humanSubject3741 
    FOREIGN KEY (subjectID)
    REFERENCES nc_humanSubject(subjectID)
;

ALTER TABLE nc_assessmentBoolean ADD CONSTRAINT Refnc_databaseUser4231 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentBoolean ADD CONSTRAINT Refnc_databaseUser4241 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentBoolean ADD CONSTRAINT Refnc_storedAssessment4591 
    FOREIGN KEY (storedAssessmentID)
    REFERENCES nc_storedAssessment(uniqueID)
;


-- 
-- TABLE: nc_assessmentData 
--

ALTER TABLE nc_assessmentData ADD CONSTRAINT Refnc_assessmentScore801 
    FOREIGN KEY (assessmentID, scoreName)
    REFERENCES nc_assessmentScore(assessmentID, scoreName)
;

/* DYW, removed tableID */
ALTER TABLE nc_assessmentData ADD CONSTRAINT Refnc_storedAssessment811 
    FOREIGN KEY (nc_storedAssessment_uniqueID)
    REFERENCES nc_storedAssessment(uniqueID)
;

ALTER TABLE nc_assessmentData ADD CONSTRAINT Refnc_databaseUser1871 
    FOREIGN KEY (keyerID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentData ADD CONSTRAINT Refnc_databaseUser1881 
    FOREIGN KEY (raterID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentData ADD CONSTRAINT Refnc_dataClassification1921 
    FOREIGN KEY (classification)
    REFERENCES nc_dataClassification(uniqueID)
;

ALTER TABLE nc_assessmentData ADD CONSTRAINT Refnc_tableID3601 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_assessmentData ADD CONSTRAINT Refnc_humanSubject3781 
    FOREIGN KEY (subjectID)
    REFERENCES nc_humanSubject(subjectID)
;

ALTER TABLE nc_assessmentData ADD CONSTRAINT Refnc_databaseUser4131 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentData ADD CONSTRAINT Refnc_databaseUser4141 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_assessmentFloat 
--

ALTER TABLE nc_assessmentFloat ADD CONSTRAINT Refnc_assessmentData851 
    FOREIGN KEY (tableID, nc_assessmentData_uniqueID)
    REFERENCES nc_assessmentData(tableID, uniqueID)
;

/* DYW, removed
ALTER TABLE nc_assessmentFloat ADD CONSTRAINT Refnc_storedAssessment1341 
    FOREIGN KEY (storedAssessmentID, tableID)
    REFERENCES nc_storedAssessment(uniqueID, tableID)
;
*/

ALTER TABLE nc_assessmentFloat ADD CONSTRAINT Refnc_assessmentScore1371 
    FOREIGN KEY (assessmentID, scoreName)
    REFERENCES nc_assessmentScore(assessmentID, scoreName)
;

ALTER TABLE nc_assessmentFloat ADD CONSTRAINT Refnc_databaseUser2061 
    FOREIGN KEY (raterID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentFloat ADD CONSTRAINT Refnc_databaseUser2071 
    FOREIGN KEY (keyerID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentFloat ADD CONSTRAINT Refnc_dataClassification2131 
    FOREIGN KEY (classification)
    REFERENCES nc_dataClassification(uniqueID)
;

ALTER TABLE nc_assessmentFloat ADD CONSTRAINT Refnc_humanSubject3751 
    FOREIGN KEY (subjectID)
    REFERENCES nc_humanSubject(subjectID)
;

ALTER TABLE nc_assessmentFloat ADD CONSTRAINT Refnc_databaseUser4171 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentFloat ADD CONSTRAINT Refnc_databaseUser4181 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentFloat ADD CONSTRAINT Refnc_storedAssessment4601 
    FOREIGN KEY (storedAssessmentID)
    REFERENCES nc_storedAssessment(uniqueID)
;


-- 
-- TABLE: nc_assessmentInformant 
--

ALTER TABLE nc_assessmentInformant ADD CONSTRAINT Refnc_ontologyConcept1761 
    FOREIGN KEY (ontologySource, conceptID, informantRelation)
    REFERENCES nc_ontologyConcept(ontologySource, conceptID, concept)
;

ALTER TABLE nc_assessmentInformant ADD CONSTRAINT Refnc_tableID3581 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_assessmentInformant ADD CONSTRAINT Refnc_databaseUser3791 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentInformant ADD CONSTRAINT Refnc_databaseUser3801 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_assessmentInteger 
--

ALTER TABLE nc_assessmentInteger ADD CONSTRAINT Refnc_assessmentData841 
    FOREIGN KEY (tableID, nc_assessmentData_uniqueID)
    REFERENCES nc_assessmentData(tableID, uniqueID)
;

/* DYW, removed tableID */
ALTER TABLE nc_assessmentInteger ADD CONSTRAINT Refnc_storedAssessment1331 
    FOREIGN KEY (storedAssessmentID)
    REFERENCES nc_storedAssessment(uniqueID)
;

ALTER TABLE nc_assessmentInteger ADD CONSTRAINT Refnc_assessmentScore1381 
    FOREIGN KEY (assessmentID, scoreName)
    REFERENCES nc_assessmentScore(assessmentID, scoreName)
;

ALTER TABLE nc_assessmentInteger ADD CONSTRAINT Refnc_databaseUser2081 
    FOREIGN KEY (raterID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentInteger ADD CONSTRAINT Refnc_databaseUser2091 
    FOREIGN KEY (keyerID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentInteger ADD CONSTRAINT Refnc_dataClassification2141 
    FOREIGN KEY (classification)
    REFERENCES nc_dataClassification(uniqueID)
;

ALTER TABLE nc_assessmentInteger ADD CONSTRAINT Refnc_humanSubject3761 
    FOREIGN KEY (subjectID)
    REFERENCES nc_humanSubject(subjectID)
;

ALTER TABLE nc_assessmentInteger ADD CONSTRAINT Refnc_databaseUser4191 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentInteger ADD CONSTRAINT Refnc_databaseUser4201 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_assessmentItem 
--

ALTER TABLE nc_assessmentItem ADD CONSTRAINT Refnc_assessmentScore1501 
    FOREIGN KEY (assessmentID, scoreName)
    REFERENCES nc_assessmentScore(assessmentID, scoreName)
;

ALTER TABLE nc_assessmentItem ADD CONSTRAINT Refnc_tableID3671 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_assessmentItem ADD CONSTRAINT Refnc_databaseUser3911 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentItem ADD CONSTRAINT Refnc_databaseUser3921 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_assessmentScore 
--

ALTER TABLE nc_assessmentScore ADD CONSTRAINT Refnc_assessment791 
    FOREIGN KEY (assessmentID)
    REFERENCES nc_assessment(assessmentID)
;

ALTER TABLE nc_assessmentScore ADD CONSTRAINT Refnc_ontologyConcept901 
    FOREIGN KEY (assessmentOntology, assessmentConcept)
    REFERENCES nc_ontologyConcept(ontologySource, conceptID)
;

ALTER TABLE nc_assessmentScore ADD CONSTRAINT Refnc_securityClassificati1211 
    FOREIGN KEY (securityClassification)
    REFERENCES nc_securityClassification(securityClassification)
;

ALTER TABLE nc_assessmentScore ADD CONSTRAINT Refnc_assessmentScore1491 
    FOREIGN KEY (parentAsID, parentScore)
    REFERENCES nc_assessmentScore(assessmentID, scoreName)
;

ALTER TABLE nc_assessmentScore ADD CONSTRAINT Refnc_tableID3611 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_assessmentScore ADD CONSTRAINT Refnc_databaseUser3971 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentScore ADD CONSTRAINT Refnc_databaseUser3981 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_assessmentScoreCode 
--

ALTER TABLE nc_assessmentScoreCode ADD CONSTRAINT Refnc_assessmentScore1551 
    FOREIGN KEY (assessmentID, scoreName)
    REFERENCES nc_assessmentScore(assessmentID, scoreName)
;

ALTER TABLE nc_assessmentScoreCode ADD CONSTRAINT Refnc_ontologyConcept1861 
    FOREIGN KEY (ontologySource, conceptID)
    REFERENCES nc_ontologyConcept(ontologySource, conceptID)
;

ALTER TABLE nc_assessmentScoreCode ADD CONSTRAINT Refnc_tableID3631 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_assessmentScoreCode ADD CONSTRAINT Refnc_databaseUser3891 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentScoreCode ADD CONSTRAINT Refnc_databaseUser3901 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_assessmentStatus 
--

ALTER TABLE nc_assessmentStatus ADD CONSTRAINT Refnc_tableID3551 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_assessmentStatus ADD CONSTRAINT Refnc_databaseUser3991 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentStatus ADD CONSTRAINT Refnc_databaseUser4001 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_assessmentTimeStamp 
--

ALTER TABLE nc_assessmentTimeStamp ADD CONSTRAINT Refnc_databaseUser2161 
    FOREIGN KEY (raterID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentTimeStamp ADD CONSTRAINT Refnc_databaseUser2171 
    FOREIGN KEY (keyerID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentTimeStamp ADD CONSTRAINT Refnc_dataClassification2181 
    FOREIGN KEY (classification)
    REFERENCES nc_dataClassification(uniqueID)
;

ALTER TABLE nc_assessmentTimeStamp ADD CONSTRAINT Refnc_assessmentData3701 
    FOREIGN KEY (tableID, nc_assessmentData_uniqueID)
    REFERENCES nc_assessmentData(tableID, uniqueID)
;

ALTER TABLE nc_assessmentTimeStamp ADD CONSTRAINT Refnc_assessmentScore3711 
    FOREIGN KEY (assessmentID, scoreName)
    REFERENCES nc_assessmentScore(assessmentID, scoreName)
;

ALTER TABLE nc_assessmentTimeStamp ADD CONSTRAINT Refnc_storedAssessment3721 
    FOREIGN KEY (storedAssessmentID)
    REFERENCES nc_storedAssessment(uniqueID)
;

ALTER TABLE nc_assessmentTimeStamp ADD CONSTRAINT Refnc_humanSubject3731 
    FOREIGN KEY (subjectID)
    REFERENCES nc_humanSubject(subjectID)
;

ALTER TABLE nc_assessmentTimeStamp ADD CONSTRAINT Refnc_databaseUser4211 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentTimeStamp ADD CONSTRAINT Refnc_databaseUser4221 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

/* DYW, dup
ALTER TABLE nc_assessmentTimeStamp ADD CONSTRAINT Refnc_storedAssessment4621 
    FOREIGN KEY (storedAssessmentID)
    REFERENCES nc_storedAssessment(uniqueID)
;
*/


-- 
-- TABLE: nc_assessmentVarchar 
--

ALTER TABLE nc_assessmentVarchar ADD CONSTRAINT Refnc_assessmentData831 
    FOREIGN KEY (tableID, nc_assessmentData_uniqueID)
    REFERENCES nc_assessmentData(tableID, uniqueID)
;

/* DYW, removed
ALTER TABLE nc_assessmentVarchar ADD CONSTRAINT Refnc_storedAssessment1351 
    FOREIGN KEY (storedAssessmentID, tableID)
    REFERENCES nc_storedAssessment(uniqueID, tableID)
;
*/

ALTER TABLE nc_assessmentVarchar ADD CONSTRAINT Refnc_assessmentScore1361 
    FOREIGN KEY (assessmentID, scoreName)
    REFERENCES nc_assessmentScore(assessmentID, scoreName)
;

ALTER TABLE nc_assessmentVarchar ADD CONSTRAINT Refnc_databaseUser2101 
    FOREIGN KEY (raterID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentVarchar ADD CONSTRAINT Refnc_databaseUser2111 
    FOREIGN KEY (keyerID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentVarchar ADD CONSTRAINT Refnc_dataClassification2151 
    FOREIGN KEY (classification)
    REFERENCES nc_dataClassification(uniqueID)
;

ALTER TABLE nc_assessmentVarchar ADD CONSTRAINT Refnc_humanSubject3771 
    FOREIGN KEY (subjectID)
    REFERENCES nc_humanSubject(subjectID)
;

ALTER TABLE nc_assessmentVarchar ADD CONSTRAINT Refnc_databaseUser4151 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentVarchar ADD CONSTRAINT Refnc_databaseUser4161 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_assessmentVarchar ADD CONSTRAINT Refnc_storedAssessment4631 
    FOREIGN KEY (storedAssessmentID)
    REFERENCES nc_storedAssessment(uniqueID)
;


-- 
-- TABLE: nc_brainSegmentData 
--

ALTER TABLE nc_brainSegmentData ADD CONSTRAINT Refnc_derivedData1731 
    FOREIGN KEY (dataID)
    REFERENCES nc_derivedData(uniqueID)
;

ALTER TABLE nc_brainSegmentData ADD CONSTRAINT Refnc_ontologyConcept1741 
    FOREIGN KEY (ontologySource, conceptID)
    REFERENCES nc_ontologyConcept(ontologySource, conceptID)
;

ALTER TABLE nc_brainSegmentData ADD CONSTRAINT Refnc_expSegment1971 
    FOREIGN KEY (segmentID, componentID, nc_experimentID, subjectID)
    REFERENCES nc_expSegment(segmentID, componentID, nc_experiment_uniqueID, subjectID)
;

ALTER TABLE nc_brainSegmentData ADD CONSTRAINT Refnc_tableID3521 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_brainSegmentData ADD CONSTRAINT Refnc_databaseUser4111 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_brainSegmentData ADD CONSTRAINT Refnc_databaseUser4121 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_brainSegmentData ADD CONSTRAINT Refnc_humanSubject4501 
    FOREIGN KEY (subjectID)
    REFERENCES nc_humanSubject(subjectID)
;


-- 
-- TABLE: nc_collectionEquipment 
--

ALTER TABLE nc_collectionEquipment ADD CONSTRAINT Refnc_tableID3431 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_compiler 
--

ALTER TABLE nc_compiler ADD CONSTRAINT Refnc_databaseUser4451 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_compiler ADD CONSTRAINT Refnc_databaseUser4461 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_compiler ADD CONSTRAINT Refnc_tableID4491 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_databaseColumn 
--

ALTER TABLE nc_databaseColumn ADD CONSTRAINT Refnc_tableID1591 
    FOREIGN KEY (tableName)
    REFERENCES nc_tableID(tableName)
;

ALTER TABLE nc_databaseColumn ADD CONSTRAINT Refnc_databaseColumn1601 
    FOREIGN KEY (parentColumn)
    REFERENCES nc_databaseColumn(columnName)
;

ALTER TABLE nc_databaseColumn ADD CONSTRAINT Refnc_tableID2671 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_databaseUser 
--

ALTER TABLE nc_databaseUser ADD CONSTRAINT Refnc_userStatus541 
    FOREIGN KEY (userStatus)
    REFERENCES nc_userStatus(uniqueID)
;

ALTER TABLE nc_databaseUser ADD CONSTRAINT Refnc_userClass551 
    FOREIGN KEY (userClass)
    REFERENCES nc_userClass(uniqueID)
;

ALTER TABLE nc_databaseUser ADD CONSTRAINT Refnc_person1121 
    FOREIGN KEY (personID)
    REFERENCES nc_person(uniqueID)
;

ALTER TABLE nc_databaseUser ADD CONSTRAINT Refnc_tableID4511 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_dataClassification 
--

ALTER TABLE nc_dataClassification ADD CONSTRAINT Refnc_tableID3591 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_dataClassification ADD CONSTRAINT Refnc_databaseUser3811 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_dataClassification ADD CONSTRAINT Refnc_databaseUser3821 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_dataObject 
--

ALTER TABLE nc_dataObject ADD CONSTRAINT Refnc_researchData2001 
    FOREIGN KEY (dataID)
    REFERENCES nc_researchData(uniqueID)
;

ALTER TABLE nc_dataObject ADD CONSTRAINT Refnc_tableID2871 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_dataObject ADD CONSTRAINT Refnc_databaseUser3051 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_dataObject ADD CONSTRAINT Refnc_databaseUser3061 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

/* DYW, dup
ALTER TABLE nc_dataObject ADD CONSTRAINT Refnc_researchData4671 
    FOREIGN KEY (dataID)
    REFERENCES nc_researchData(uniqueID)
;
*/


-- 
-- TABLE: nc_dbColumnUnit 
--

ALTER TABLE nc_dbColumnUnit ADD CONSTRAINT Refnc_databaseColumn1661 
    FOREIGN KEY (columnName)
    REFERENCES nc_databaseColumn(columnName)
;

ALTER TABLE nc_dbColumnUnit ADD CONSTRAINT Refnc_measurementUnit1681 
    FOREIGN KEY (measurementSystem, unit)
    REFERENCES nc_measurementUnit(measurementSystem, unit)
;

ALTER TABLE nc_dbColumnUnit ADD CONSTRAINT Refnc_tableID2631 
    FOREIGN KEY (columnTable)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_dbColumnUnit ADD CONSTRAINT Refnc_tableID4581 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_dbColumnUnit ADD CONSTRAINT Refnc_databaseUser4681 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_dbColumnUnit ADD CONSTRAINT Refnc_databaseUser4691 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_derivedData 
--

ALTER TABLE nc_derivedData ADD CONSTRAINT Refnc_researchData1081 
    FOREIGN KEY (uniqueID)
    REFERENCES nc_researchData(uniqueID)
;

ALTER TABLE nc_derivedData ADD CONSTRAINT Refnc_ontologyConcept1181 
    FOREIGN KEY (ontologySource, conceptID)
    REFERENCES nc_ontologyConcept(ontologySource, conceptID)
;

ALTER TABLE nc_derivedData ADD CONSTRAINT Refnc_expSegment1961 
    FOREIGN KEY (segmentID, componentID, nc_experiment_uniqueID, subjectID)
    REFERENCES nc_expSegment(segmentID, componentID, nc_experiment_uniqueID, subjectID)
;

ALTER TABLE nc_derivedData ADD CONSTRAINT Refnc_tableID2851 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_derivedData ADD CONSTRAINT Refnc_databaseUser2951 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_derivedData ADD CONSTRAINT Refnc_databaseUser2961 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_derivedData ADD CONSTRAINT Refnc_humanSubject4521 
    FOREIGN KEY (subjectID)
    REFERENCES nc_humanSubject(subjectID)
;


-- 
-- TABLE: nc_executedTransform 
--

ALTER TABLE nc_executedTransform ADD CONSTRAINT Refnc_transformation1021 
    FOREIGN KEY (logicalTransformID)
    REFERENCES nc_transformation(uniqueID)
;

ALTER TABLE nc_executedTransform ADD CONSTRAINT Refnc_databaseUser1131 
    FOREIGN KEY (nc_databaseUser_uniqueID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_executedTransform ADD CONSTRAINT Refnc_machine1141 
    FOREIGN KEY (machineID)
    REFERENCES nc_machine(uniqueID)
;

ALTER TABLE nc_executedTransform ADD CONSTRAINT Refnc_tableID2811 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_executedTransform ADD CONSTRAINT Refnc_databaseUser2991 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_executedTransform ADD CONSTRAINT Refnc_databaseUser3001 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_executedTransform ADD CONSTRAINT Refnc_compiler4401 
    FOREIGN KEY (compilerID)
    REFERENCES nc_compiler(uniqueID)
;


-- 
-- TABLE: nc_expComponent 
--

ALTER TABLE nc_expComponent ADD CONSTRAINT Refnc_experiment141 
    FOREIGN KEY (nc_experiment_uniqueID)
    REFERENCES nc_experiment(uniqueID)
;

ALTER TABLE nc_expComponent ADD CONSTRAINT Refnc_humanSubject151 
    FOREIGN KEY (subjectID)
    REFERENCES nc_humanSubject(subjectID)
;

ALTER TABLE nc_expComponent ADD CONSTRAINT Refnc_visitType171 
    FOREIGN KEY (visitType)
    REFERENCES nc_visitType(visitType)
;

ALTER TABLE nc_expComponent ADD CONSTRAINT Refnc_tableID3511 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_expComponent ADD CONSTRAINT Refnc_databaseUser3851 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_expComponent ADD CONSTRAINT Refnc_databaseUser3861 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_expCondition 
--

ALTER TABLE nc_expCondition ADD CONSTRAINT Refnc_expManipulation301 
    FOREIGN KEY (expManipulationID)
    REFERENCES nc_expManipulation(uniqueID)
;

ALTER TABLE nc_expCondition ADD CONSTRAINT Refnc_ontologyConcept1251 
    FOREIGN KEY (ontologySource, conceptID)
    REFERENCES nc_ontologyConcept(ontologySource, conceptID)
;

ALTER TABLE nc_expCondition ADD CONSTRAINT Refnc_tableID3441 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_expCondition ADD CONSTRAINT Refnc_databaseUser4741 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_expCondition ADD CONSTRAINT Refnc_databaseUser4751 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_experiment 
--

ALTER TABLE nc_experiment ADD CONSTRAINT Refnc_person131 
    FOREIGN KEY (contactPerson)
    REFERENCES nc_person(uniqueID)
;

ALTER TABLE nc_experiment ADD CONSTRAINT Refnc_databaseUser2291 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_experiment ADD CONSTRAINT Refnc_databaseUser2301 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_experiment ADD CONSTRAINT Refnc_tableID2721 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_expEvent 
--

ALTER TABLE nc_expEvent ADD CONSTRAINT Refnc_expManipulation321 
    FOREIGN KEY (expManipulationID)
    REFERENCES nc_expManipulation(uniqueID)
;

ALTER TABLE nc_expEvent ADD CONSTRAINT Refnc_ontologyConcept1261 
    FOREIGN KEY (ontologySource, conceptID)
    REFERENCES nc_ontologyConcept(ontologySource, conceptID)
;

ALTER TABLE nc_expEvent ADD CONSTRAINT Refnc_tableID3411 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_expEvent ADD CONSTRAINT Refnc_databaseUser4761 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_expEvent ADD CONSTRAINT Refnc_databaseUser4771 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_expManipulation 
--

ALTER TABLE nc_expManipulation ADD CONSTRAINT Refnc_ontologyConcept1231 
    FOREIGN KEY (ontologySource, conceptID)
    REFERENCES nc_ontologyConcept(ontologySource, conceptID)
;

ALTER TABLE nc_expManipulation ADD CONSTRAINT Refnc_tableID3451 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_expSegment 
--

ALTER TABLE nc_expSegment ADD CONSTRAINT Refnc_expComponent161 
    FOREIGN KEY (componentID, nc_experiment_uniqueID, subjectID)
    REFERENCES nc_expComponent(componentID, nc_experiment_uniqueID, subjectID)
;

ALTER TABLE nc_expSegment ADD CONSTRAINT Refnc_protocol201 
    FOREIGN KEY (protocolVersion, protocolID)
    REFERENCES nc_protocol(protocolVersion, protocolID)
;

ALTER TABLE nc_expSegment ADD CONSTRAINT Refnc_expStudy2021 
    FOREIGN KEY (studyID, componentID, nc_experiment_uniqueID, subjectID)
    REFERENCES nc_expStudy(studyID, componentID, experimentID, subjectID)
;

ALTER TABLE nc_expSegment ADD CONSTRAINT Refnc_tableID3481 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_expSegment ADD CONSTRAINT Refnc_databaseUser3871 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_expSegment ADD CONSTRAINT Refnc_databaseUser3881 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_expStudy 
--

ALTER TABLE nc_expStudy ADD CONSTRAINT Refnc_expComponent2031 
    FOREIGN KEY (componentID, experimentID, subjectID)
    REFERENCES nc_expComponent(componentID, nc_experiment_uniqueID, subjectID)
;

ALTER TABLE nc_expStudy ADD CONSTRAINT Refnc_tableID3491 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_extendedTuple 
--

ALTER TABLE nc_extendedTuple ADD CONSTRAINT Refnc_tupleSubClass631 
    FOREIGN KEY (tupleSubClass, tupleClass)
    REFERENCES nc_tupleSubClass(tupleSubClass, tupleClass)
;

ALTER TABLE nc_extendedTuple ADD CONSTRAINT Refnc_tableID3171 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_extendedTuple ADD CONSTRAINT Refnc_databaseUser3351 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_extendedTuple ADD CONSTRAINT Refnc_databaseUser3361 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_humanSubject 
--

ALTER TABLE nc_humanSubject ADD CONSTRAINT Refnc_animalSpecies21 
    FOREIGN KEY (nc_animalSpecies_uniqueID)
    REFERENCES nc_animalSpecies(uniqueID)
;

/* DYW, no trigger to populate the parent table
ALTER TABLE nc_humanSubject ADD CONSTRAINT Refnc_researchSubject2191 
    FOREIGN KEY (subjectID)
    REFERENCES nc_researchSubject(subjectID)
;
*/

ALTER TABLE nc_humanSubject ADD CONSTRAINT Refnc_databaseUser2411 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_humanSubject ADD CONSTRAINT Refnc_databaseUser2421 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_humanSubject ADD CONSTRAINT Refnc_tableID2741 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_machine 
--

ALTER TABLE nc_machine ADD CONSTRAINT Refnc_tableID2791 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_machine ADD CONSTRAINT Refnc_databaseUser3091 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_machine ADD CONSTRAINT Refnc_databaseUser3101 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_maskValidator 
--

ALTER TABLE nc_maskValidator ADD CONSTRAINT Refnc_tableID3621 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_maskValidator ADD CONSTRAINT Refnc_databaseUser4051 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_maskValidator ADD CONSTRAINT Refnc_databaseUser4061 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_measurementSystem 
--

ALTER TABLE nc_measurementSystem ADD CONSTRAINT Refnc_tableID2641 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_measurementSystem ADD CONSTRAINT Refnc_databaseUser4841 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_measurementSystem ADD CONSTRAINT Refnc_databaseUser4851 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_measurementType 
--

ALTER TABLE nc_measurementType ADD CONSTRAINT Refnc_tableID2661 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_measurementType ADD CONSTRAINT Refnc_databaseUser4861 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_measurementType ADD CONSTRAINT Refnc_databaseUser4871 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_measurementUnit 
--

ALTER TABLE nc_measurementUnit ADD CONSTRAINT Refnc_measurementSystem1691 
    FOREIGN KEY (measurementSystem)
    REFERENCES nc_measurementSystem(name)
;

ALTER TABLE nc_measurementUnit ADD CONSTRAINT Refnc_measurementType1701 
    FOREIGN KEY (measurementType)
    REFERENCES nc_measurementType(name)
;

ALTER TABLE nc_measurementUnit ADD CONSTRAINT Refnc_measurementUnit1711 
    FOREIGN KEY (measurementSystem, conversionUnit)
    REFERENCES nc_measurementUnit(measurementSystem, unit)
;

ALTER TABLE nc_measurementUnit ADD CONSTRAINT Refnc_tableID2651 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_measurementUnit ADD CONSTRAINT Refnc_databaseUser4881 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_measurementUnit ADD CONSTRAINT Refnc_databaseUser4891 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_ontologyConcept 
--

ALTER TABLE nc_ontologyConcept ADD CONSTRAINT Refnc_ontologySource771 
    FOREIGN KEY (ontologySource)
    REFERENCES nc_ontologySource(ontologySource)
;

ALTER TABLE nc_ontologyConcept ADD CONSTRAINT Refnc_tableID2781 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_ontologyConcept ADD CONSTRAINT Refnc_databaseUser2931 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_ontologyConcept ADD CONSTRAINT Refnc_databaseUser2941 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_ontologySource 
--

ALTER TABLE nc_ontologySource ADD CONSTRAINT Refnc_tableID2771 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_ontologySource ADD CONSTRAINT Refnc_databaseUser3131 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_ontologySource ADD CONSTRAINT Refnc_databaseUser3141 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_person 
--

ALTER TABLE nc_person ADD CONSTRAINT Refnc_databaseUser2251 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_person ADD CONSTRAINT Refnc_databaseUser2261 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_person ADD CONSTRAINT Refnc_tableID2691 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_protocol 
--

ALTER TABLE nc_protocol ADD CONSTRAINT Refnc_tableID3471 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_protocolManip 
--

ALTER TABLE nc_protocolManip ADD CONSTRAINT Refnc_protocol211 
    FOREIGN KEY (protocolVersion, protocolID)
    REFERENCES nc_protocol(protocolVersion, protocolID)
;

ALTER TABLE nc_protocolManip ADD CONSTRAINT Refnc_expManipulation281 
    FOREIGN KEY (nc_expManipulation_uniqueID)
    REFERENCES nc_expManipulation(uniqueID)
;

ALTER TABLE nc_protocolManip ADD CONSTRAINT Refnc_tableID3461 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_rangeValidator 
--

ALTER TABLE nc_rangeValidator ADD CONSTRAINT Refnc_tableID3661 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_rangeValidator ADD CONSTRAINT Refnc_databaseUser4031 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_rangeValidator ADD CONSTRAINT Refnc_databaseUser4041 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_rawData 
--

ALTER TABLE nc_rawData ADD CONSTRAINT Refnc_expSegment181 
    FOREIGN KEY (segmentID, componentID, nc_experiment_uniqueID, subjectID)
    REFERENCES nc_expSegment(segmentID, componentID, nc_experiment_uniqueID, subjectID)
;

ALTER TABLE nc_rawData ADD CONSTRAINT Refnc_protocol191 
    FOREIGN KEY (protocolVersion, protocolID)
    REFERENCES nc_protocol(protocolVersion, protocolID)
;

ALTER TABLE nc_rawData ADD CONSTRAINT Refnc_collectionEquipment951 
    FOREIGN KEY (nc_colEquipment_uniqueID)
    REFERENCES nc_collectionEquipment(uniqueID)
;

ALTER TABLE nc_rawData ADD CONSTRAINT Refnc_researchData971 
    FOREIGN KEY (uniqueID)
    REFERENCES nc_researchData(uniqueID)
;

ALTER TABLE nc_rawData ADD CONSTRAINT Refnc_ontologyConcept1171 
    FOREIGN KEY (ontologySource, conceptID)
    REFERENCES nc_ontologyConcept(ontologySource, conceptID)
;

ALTER TABLE nc_rawData ADD CONSTRAINT Refnc_tableID2861 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_rawData ADD CONSTRAINT Refnc_databaseUser3071 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_rawData ADD CONSTRAINT Refnc_databaseUser3081 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_researchData 
--

ALTER TABLE nc_researchData ADD CONSTRAINT Refnc_ontologyConcept1151 
    FOREIGN KEY (dataOntology, dataClass)
    REFERENCES nc_ontologyConcept(ontologySource, conceptID)
;

ALTER TABLE nc_researchData ADD CONSTRAINT Refnc_tableID2831 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_researchData ADD CONSTRAINT Refnc_databaseUser3031 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_researchData ADD CONSTRAINT Refnc_databaseUser3041 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_researchGroup 
--

ALTER TABLE nc_researchGroup ADD CONSTRAINT Refnc_researchGroupType91 
    FOREIGN KEY (nc_researchGroupType_uniqueID)
    REFERENCES nc_researchGroupType(uniqueID)
;

ALTER TABLE nc_researchGroup ADD CONSTRAINT Refnc_experiment101 
    FOREIGN KEY (nc_experiment_uniqueID)
    REFERENCES nc_experiment(uniqueID)
;

ALTER TABLE nc_researchGroup ADD CONSTRAINT Refnc_databaseUser2381 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_researchGroup ADD CONSTRAINT Refnc_databaseUser2391 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_researchGroup ADD CONSTRAINT Refnc_tableID2751 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_researchGroupType 
--

ALTER TABLE nc_researchGroupType ADD CONSTRAINT Refnc_databaseUser2221 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_researchGroupType ADD CONSTRAINT Refnc_databaseUser2231 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_researchGroupType ADD CONSTRAINT Refnc_tableID2731 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_researchSubject 
--

ALTER TABLE nc_researchSubject ADD CONSTRAINT Refnc_animalSpecies2201 
    FOREIGN KEY (speciesID)
    REFERENCES nc_animalSpecies(uniqueID)
;

ALTER TABLE nc_researchSubject ADD CONSTRAINT Refnc_databaseUser2351 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_researchSubject ADD CONSTRAINT Refnc_databaseUser2361 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_researchSubject ADD CONSTRAINT Refnc_tableID2711 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_schemaVersion 
--

ALTER TABLE nc_schemaVersion ADD CONSTRAINT Refnc_tableID2621 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_scoreValidation 
--

ALTER TABLE nc_scoreValidation ADD CONSTRAINT Refnc_databaseUser1891 
    FOREIGN KEY (validatorID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_scoreValidation ADD CONSTRAINT Refnc_assessmentData1901 
    FOREIGN KEY (tableID, dataID, assessmentID)
    REFERENCES nc_assessmentData(tableID, uniqueID, assessmentID)
;

ALTER TABLE nc_scoreValidation ADD CONSTRAINT Refnc_validationMethod1951 
    FOREIGN KEY (method)
    REFERENCES nc_validationMethod(method)
;

ALTER TABLE nc_scoreValidation ADD CONSTRAINT Refnc_tableID3561 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_scoreValidation ADD CONSTRAINT Refnc_databaseUser4091 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_scoreValidation ADD CONSTRAINT Refnc_databaseUser4101 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_scoreValidator 
--

ALTER TABLE nc_scoreValidator ADD CONSTRAINT Refnc_assessmentScore1821 
    FOREIGN KEY (assessmentID, scoreName)
    REFERENCES nc_assessmentScore(assessmentID, scoreName)
;

ALTER TABLE nc_scoreValidator ADD CONSTRAINT Refnc_rangeValidator1841 
    FOREIGN KEY (validatorID)
    REFERENCES nc_rangeValidator(uniqueID)
;

ALTER TABLE nc_scoreValidator ADD CONSTRAINT Refnc_maskValidator1851 
    FOREIGN KEY (validatorID)
    REFERENCES nc_maskValidator(uniqueID)
;

ALTER TABLE nc_scoreValidator ADD CONSTRAINT Refnc_tableID3651 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_scoreValidator ADD CONSTRAINT Refnc_databaseUser4071 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_scoreValidator ADD CONSTRAINT Refnc_databaseUser4081 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_securityClassification 
--

ALTER TABLE nc_securityClassification ADD CONSTRAINT Refnc_tableID3681 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_securityClassification ADD CONSTRAINT Refnc_databaseUser3931 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_securityClassification ADD CONSTRAINT Refnc_databaseUser3941 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_storedAssessment 
--

ALTER TABLE nc_storedAssessment ADD CONSTRAINT Refnc_assessment751 
    FOREIGN KEY (assessmentID)
    REFERENCES nc_assessment(assessmentID)
;

ALTER TABLE nc_storedAssessment ADD CONSTRAINT Refnc_expSegment1481 
    FOREIGN KEY (segmentID, componentID, nc_experiment_uniqueID, subjectID)
    REFERENCES nc_expSegment(segmentID, componentID, nc_experiment_uniqueID, subjectID)
;

ALTER TABLE nc_storedAssessment ADD CONSTRAINT Refnc_assessmentInformant1771 
    FOREIGN KEY (informantRelation)
    REFERENCES nc_assessmentInformant(informantRelation)
;

ALTER TABLE nc_storedAssessment ADD CONSTRAINT Refnc_humanSubject1791 
    FOREIGN KEY (subjectID)
    REFERENCES nc_humanSubject(subjectID)
;

ALTER TABLE nc_storedAssessment ADD CONSTRAINT Refnc_assessmentStatus1941 
    FOREIGN KEY (status)
    REFERENCES nc_assessmentStatus(status)
;

ALTER TABLE nc_storedAssessment ADD CONSTRAINT Refnc_tableID3571 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_storedAssessment ADD CONSTRAINT Refnc_databaseUser3831 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_storedAssessment ADD CONSTRAINT Refnc_databaseUser3841 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_storedAssessment ADD CONSTRAINT Refnc_humanSubject4321 
    FOREIGN KEY (informantID)
    REFERENCES nc_humanSubject(subjectID)
;


-- 
-- TABLE: nc_storedQuery 
--

ALTER TABLE nc_storedQuery ADD CONSTRAINT Refnc_tableID4571 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_storedQuery ADD CONSTRAINT Refnc_databaseUser4921 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_storedQuery ADD CONSTRAINT Refnc_databaseUser4931 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_storedTuple 
--

ALTER TABLE nc_storedTuple ADD CONSTRAINT Refnc_extendedTuple601 
    FOREIGN KEY (extendedTupleID)
    REFERENCES nc_extendedTuple(uniqueID)
;

ALTER TABLE nc_storedTuple ADD CONSTRAINT Refnc_expCondition931 
    FOREIGN KEY (baseTupleID)
    REFERENCES nc_expCondition(expManipulationID)
;

ALTER TABLE nc_storedTuple ADD CONSTRAINT Refnc_expEvent941 
    FOREIGN KEY (baseTupleID)
    REFERENCES nc_expEvent(expManipulationID)
;

ALTER TABLE nc_storedTuple ADD CONSTRAINT Refnc_collectionEquipment961 
    FOREIGN KEY (baseTupleID)
    REFERENCES nc_collectionEquipment(uniqueID)
;

ALTER TABLE nc_storedTuple ADD CONSTRAINT Refnc_databaseUser3271 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_storedTuple ADD CONSTRAINT Refnc_databaseUser3281 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_subjExperiment 
--

ALTER TABLE nc_subjExperiment ADD CONSTRAINT Refnc_experiment71 
    FOREIGN KEY (nc_experiment_uniqueID)
    REFERENCES nc_experiment(uniqueID)
;

ALTER TABLE nc_subjExperiment ADD CONSTRAINT Refnc_humanSubject81 
    FOREIGN KEY (subjectID)
    REFERENCES nc_humanSubject(subjectID)
;

ALTER TABLE nc_subjExperiment ADD CONSTRAINT Refnc_researchGroup121 
    FOREIGN KEY (nc_researchGroup_uniqueID)
    REFERENCES nc_researchGroup(uniqueID)
;

ALTER TABLE nc_subjExperiment ADD CONSTRAINT Refnc_databaseUser2441 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_subjExperiment ADD CONSTRAINT Refnc_databaseUser2451 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_subjExperiment ADD CONSTRAINT Refnc_tableID2761 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_tableID 
--

ALTER TABLE nc_tableID ADD CONSTRAINT Refnc_schemaVersion1581 
    FOREIGN KEY (majorVersion, minorVersion)
    REFERENCES nc_schemaVersion(majorVersion, minorVersion)
;

ALTER TABLE nc_tableID ADD CONSTRAINT Refnc_databaseUser3111 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tableID ADD CONSTRAINT Refnc_databaseUser3121 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_transformation 
--

ALTER TABLE nc_transformation ADD CONSTRAINT Refnc_ontologyConcept1051 
    FOREIGN KEY (ontologySource, conceptID)
    REFERENCES nc_ontologyConcept(ontologySource, conceptID)
;

ALTER TABLE nc_transformation ADD CONSTRAINT Refnc_tableID2801 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_transformation ADD CONSTRAINT Refnc_databaseUser2911 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_transformation ADD CONSTRAINT Refnc_databaseUser2921 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_transformationArgument 
--

ALTER TABLE nc_transformationArgument ADD CONSTRAINT Refnc_transformation1011 
    FOREIGN KEY (transformID)
    REFERENCES nc_transformation(uniqueID)
;

ALTER TABLE nc_transformationArgument ADD CONSTRAINT Refnc_tableID2821 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_transformationArgument ADD CONSTRAINT Refnc_databaseUser2891 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_transformationArgument ADD CONSTRAINT Refnc_databaseUser2901 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_transformationLibrary 
--

ALTER TABLE nc_transformationLibrary ADD CONSTRAINT Refnc_databaseUser4431 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_transformationLibrary ADD CONSTRAINT Refnc_databaseUser4441 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_transformationLibrary ADD CONSTRAINT Refnc_tableID4471 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_transformedData 
--

ALTER TABLE nc_transformedData ADD CONSTRAINT Refnc_derivedData1191 
    FOREIGN KEY (nc_researchData_uniqueID)
    REFERENCES nc_derivedData(uniqueID)
;

ALTER TABLE nc_transformedData ADD CONSTRAINT Refnc_executedTransform1201 
    FOREIGN KEY (nc_executedTransform_uniqueID)
    REFERENCES nc_executedTransform(uniqueID)
;

ALTER TABLE nc_transformedData ADD CONSTRAINT Refnc_tableID2881 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_transformedData ADD CONSTRAINT Refnc_databaseUser2971 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_transformedData ADD CONSTRAINT Refnc_databaseUser2981 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_tupleAccess 
--

ALTER TABLE nc_tupleAccess ADD CONSTRAINT Refnc_databaseUser571 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleAccess ADD CONSTRAINT Refnc_databaseUser581 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleAccess ADD CONSTRAINT Refnc_databaseUser2471 
    FOREIGN KEY (grantor)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleAccess ADD CONSTRAINT Refnc_databaseUser2481 
    FOREIGN KEY (grantee)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_tupleBoolean 
--

ALTER TABLE nc_tupleBoolean ADD CONSTRAINT Refnc_tupleData711 
    FOREIGN KEY (tableID, uniqueID)
    REFERENCES nc_tupleData(tableID, uniqueID)
;

ALTER TABLE nc_tupleBoolean ADD CONSTRAINT Refnc_tupleColumns1401 
    FOREIGN KEY (extendedTupleID, columnName, columnType)
    REFERENCES nc_tupleColumns(extendedTupleID, columnName, columnType)
;

ALTER TABLE nc_tupleBoolean ADD CONSTRAINT Refnc_storedTuple1441 
    FOREIGN KEY (baseTableID, extendedTupleID)
    REFERENCES nc_storedTuple(baseTableID, extendedTupleID)
;

ALTER TABLE nc_tupleBoolean ADD CONSTRAINT Refnc_databaseUser3211 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleBoolean ADD CONSTRAINT Refnc_databaseUser3221 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_tupleClass 
--

ALTER TABLE nc_tupleClass ADD CONSTRAINT Refnc_tableID3191 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_tupleClass ADD CONSTRAINT Refnc_databaseUser3371 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleClass ADD CONSTRAINT Refnc_databaseUser3381 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_tupleColumns 
--

ALTER TABLE nc_tupleColumns ADD CONSTRAINT Refnc_extendedTuple641 
    FOREIGN KEY (extendedTupleID)
    REFERENCES nc_extendedTuple(uniqueID)
;

ALTER TABLE nc_tupleColumns ADD CONSTRAINT Refnc_ontologyConcept1221 
    FOREIGN KEY (columnOntology, columnConcept)
    REFERENCES nc_ontologyConcept(ontologySource, conceptID)
;

ALTER TABLE nc_tupleColumns ADD CONSTRAINT Refnc_measurementUnit1751 
    FOREIGN KEY (measurementSystem, measurementUnit)
    REFERENCES nc_measurementUnit(measurementSystem, unit)
;

ALTER TABLE nc_tupleColumns ADD CONSTRAINT Refnc_tableID3151 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_tupleColumns ADD CONSTRAINT Refnc_databaseUser3331 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleColumns ADD CONSTRAINT Refnc_databaseUser3341 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_tupleData 
--

ALTER TABLE nc_tupleData ADD CONSTRAINT Refnc_tupleColumns651 
    FOREIGN KEY (extendedTupleID, columnName, columnType)
    REFERENCES nc_tupleColumns(extendedTupleID, columnName, columnType)
;

ALTER TABLE nc_tupleData ADD CONSTRAINT Refnc_storedTuple661 
    FOREIGN KEY (baseTableID, extendedTupleID)
    REFERENCES nc_storedTuple(baseTableID, extendedTupleID)
;

ALTER TABLE nc_tupleData ADD CONSTRAINT Refnc_tableID3161 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_tupleData ADD CONSTRAINT Refnc_databaseUser3291 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleData ADD CONSTRAINT Refnc_databaseUser3301 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_tupleFloat 
--

ALTER TABLE nc_tupleFloat ADD CONSTRAINT Refnc_tupleData741 
    FOREIGN KEY (tableID, uniqueID)
    REFERENCES nc_tupleData(tableID, uniqueID)
;

ALTER TABLE nc_tupleFloat ADD CONSTRAINT Refnc_tupleColumns1421 
    FOREIGN KEY (extendedTupleID, columnName, columnType)
    REFERENCES nc_tupleColumns(extendedTupleID, columnName, columnType)
;

ALTER TABLE nc_tupleFloat ADD CONSTRAINT Refnc_storedTuple1461 
    FOREIGN KEY (baseTableID, extendedTupleID)
    REFERENCES nc_storedTuple(baseTableID, extendedTupleID)
;

ALTER TABLE nc_tupleFloat ADD CONSTRAINT Refnc_databaseUser3231 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleFloat ADD CONSTRAINT Refnc_databaseUser3241 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_tupleInteger 
--

ALTER TABLE nc_tupleInteger ADD CONSTRAINT Refnc_tupleData731 
    FOREIGN KEY (tableID, uniqueID)
    REFERENCES nc_tupleData(tableID, uniqueID)
;

ALTER TABLE nc_tupleInteger ADD CONSTRAINT Refnc_tupleColumns1411 
    FOREIGN KEY (extendedTupleID, columnName, columnType)
    REFERENCES nc_tupleColumns(extendedTupleID, columnName, columnType)
;

ALTER TABLE nc_tupleInteger ADD CONSTRAINT Refnc_storedTuple1451 
    FOREIGN KEY (baseTableID, extendedTupleID)
    REFERENCES nc_storedTuple(baseTableID, extendedTupleID)
;

ALTER TABLE nc_tupleInteger ADD CONSTRAINT Refnc_databaseUser3251 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleInteger ADD CONSTRAINT Refnc_databaseUser3261 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_tupleSubClass 
--

ALTER TABLE nc_tupleSubClass ADD CONSTRAINT Refnc_tupleClass621 
    FOREIGN KEY (tupleClass)
    REFERENCES nc_tupleClass(tupleClass)
;

ALTER TABLE nc_tupleSubClass ADD CONSTRAINT Refnc_tableID3181 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_tupleSubClass ADD CONSTRAINT Refnc_databaseUser3391 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleSubClass ADD CONSTRAINT Refnc_databaseUser3401 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_tupleTimestamp 
--

ALTER TABLE nc_tupleTimestamp ADD CONSTRAINT Refnc_tupleData4251 
    FOREIGN KEY (tableID, uniqueID)
    REFERENCES nc_tupleData(tableID, uniqueID)
;

ALTER TABLE nc_tupleTimestamp ADD CONSTRAINT Refnc_tableID4261 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_tupleTimestamp ADD CONSTRAINT Refnc_databaseUser4271 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleTimestamp ADD CONSTRAINT Refnc_databaseUser4291 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleTimestamp ADD CONSTRAINT Refnc_storedTuple4301 
    FOREIGN KEY (baseTableID, extendedTupleID)
    REFERENCES nc_storedTuple(baseTableID, extendedTupleID)
;

ALTER TABLE nc_tupleTimestamp ADD CONSTRAINT Refnc_tupleColumns4311 
    FOREIGN KEY (extendedTupleID, columnName, columnType)
    REFERENCES nc_tupleColumns(extendedTupleID, columnName, columnType)
;


-- 
-- TABLE: nc_tupleVarchar 
--

ALTER TABLE nc_tupleVarchar ADD CONSTRAINT Refnc_tupleData721 
    FOREIGN KEY (tableID, uniqueID)
    REFERENCES nc_tupleData(tableID, uniqueID)
;

ALTER TABLE nc_tupleVarchar ADD CONSTRAINT Refnc_tupleColumns1431 
    FOREIGN KEY (extendedTupleID, columnName, columnType)
    REFERENCES nc_tupleColumns(extendedTupleID, columnName, columnType)
;

ALTER TABLE nc_tupleVarchar ADD CONSTRAINT Refnc_storedTuple1471 
    FOREIGN KEY (baseTableID, extendedTupleID)
    REFERENCES nc_storedTuple(baseTableID, extendedTupleID)
;

ALTER TABLE nc_tupleVarchar ADD CONSTRAINT Refnc_databaseUser3311 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_tupleVarchar ADD CONSTRAINT Refnc_databaseUser3321 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_updateLog 
--

ALTER TABLE nc_updateLog ADD CONSTRAINT Refnc_databaseUser2681 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_usedArgument 
--

ALTER TABLE nc_usedArgument ADD CONSTRAINT Refnc_executedTransform1061 
    FOREIGN KEY (nc_executedTransform_uniqueID)
    REFERENCES nc_executedTransform(uniqueID)
;

ALTER TABLE nc_usedArgument ADD CONSTRAINT Refnc_transformationArgume1071 
    FOREIGN KEY (transformationArgID)
    REFERENCES nc_transformationArgument(uniqueID)
;

ALTER TABLE nc_usedArgument ADD CONSTRAINT Refnc_researchData1161 
    FOREIGN KEY (uniqueID)
    REFERENCES nc_researchData(uniqueID)
;

ALTER TABLE nc_usedArgument ADD CONSTRAINT Refnc_tableID2841 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_usedArgument ADD CONSTRAINT Refnc_databaseUser3011 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_usedArgument ADD CONSTRAINT Refnc_databaseUser3021 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_usedLibrary 
--

ALTER TABLE nc_usedLibrary ADD CONSTRAINT Refnc_executedTransform4341 
    FOREIGN KEY (executedTransformID)
    REFERENCES nc_executedTransform(uniqueID)
;

ALTER TABLE nc_usedLibrary ADD CONSTRAINT Refnc_transformationLibrar4361 
    FOREIGN KEY (libraryID)
    REFERENCES nc_transformationLibrary(uniqueID)
;

ALTER TABLE nc_usedLibrary ADD CONSTRAINT Refnc_databaseUser4411 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_usedLibrary ADD CONSTRAINT Refnc_databaseUser4421 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_usedLibrary ADD CONSTRAINT Refnc_tableID4481 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


-- 
-- TABLE: nc_userClass 
--

ALTER TABLE nc_userClass ADD CONSTRAINT Refnc_tableID4541 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_userClass ADD CONSTRAINT Refnc_databaseUser5001 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_userClass ADD CONSTRAINT Refnc_databaseUser5011 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_userGroup 
--

ALTER TABLE nc_userGroup ADD CONSTRAINT Refnc_databaseUser461 
    FOREIGN KEY (userID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_userGroup ADD CONSTRAINT Refnc_databaseUser471 
    FOREIGN KEY (groupID)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_userGroup ADD CONSTRAINT Refnc_tableID4551 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_userGroup ADD CONSTRAINT Refnc_databaseUser5021 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_userGroup ADD CONSTRAINT Refnc_databaseUser5031 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_userStatus 
--

ALTER TABLE nc_userStatus ADD CONSTRAINT Refnc_tableID4561 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_userStatus ADD CONSTRAINT Refnc_databaseUser5041 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_userStatus ADD CONSTRAINT Refnc_databaseUser5051 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_validationMethod 
--

ALTER TABLE nc_validationMethod ADD CONSTRAINT Refnc_tableID3541 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;

ALTER TABLE nc_validationMethod ADD CONSTRAINT Refnc_databaseUser4011 
    FOREIGN KEY (owner)
    REFERENCES nc_databaseUser(uniqueID)
;

ALTER TABLE nc_validationMethod ADD CONSTRAINT Refnc_databaseUser4021 
    FOREIGN KEY (modUser)
    REFERENCES nc_databaseUser(uniqueID)
;


-- 
-- TABLE: nc_visitType 
--

ALTER TABLE nc_visitType ADD CONSTRAINT Refnc_tableID3501 
    FOREIGN KEY (tableID)
    REFERENCES nc_tableID(tableID)
;


