DROP TABLE nc_animalSpecies CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_animalSpecies 
--

CREATE TABLE nc_animalSpecies(
    uniqueID       NUMBER(38, 0)    NOT NULL,
    tableID        NUMBER(38, 0)    NOT NULL,
    owner          NUMBER(38, 0)    NOT NULL,
    modTime        DATE             NOT NULL,
    modUser        NUMBER(38, 0)    NOT NULL,
    name           VARCHAR2(128)    NOT NULL,
    strain         VARCHAR2(128),
    latinName      VARCHAR2(128),
    description    CLOB,
    CONSTRAINT nc_animalSpecies_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_animalSpecies_pidx on nc_animalSpecies(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_animalSpecies_sk  UNIQUE (tableID, uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_animalSpecies_sidx on nc_animalSpecies(tableID, uniqueID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON TABLE nc_animalSpecies IS 'The nc_animalSpecies table provides the information to classify the species of a research subject (i.e. for the nc_researchSubject table and its children, e.g. nc_humanSubject).'
;
COMMENT ON COLUMN nc_animalSpecies.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_animalSpecies.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_animalSpecies.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_animalSpecies.modTime IS 'The modTimecolumn is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who entered the data (modUser) and when (modTime).  Taken together with a core table (nc_TABLENAME) and its backing table (bk_TABLENAME which is used to store the history of changes to a tuple) modTime allows one to fully recreate the history of every tuple stored in a core table.'
;
COMMENT ON COLUMN nc_animalSpecies.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_animalSpecies.name IS 'The name column is used for the common name of a species.'
;
COMMENT ON COLUMN nc_animalSpecies.strain IS 'The straincolumn is used for the name of the strain of a species.'
;
COMMENT ON COLUMN nc_animalSpecies.latinName IS 'The latinName column is used for the common name of a species.
'
;
COMMENT ON COLUMN nc_animalSpecies.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
