DROP TABLE nc_brainSegmentData CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_brainSegmentData 
--

CREATE TABLE nc_brainSegmentData(
    dataID               NUMBER(38, 0)       NOT NULL,
    tableID              NUMBER(38, 0)       NOT NULL,
    segmentID            NUMBER(38, 0),
    componentID          NUMBER(38, 0),
    nc_experimentID      NUMBER(38, 0),
    subjectID            VARCHAR2(64)        NOT NULL,
    brainRegionName      VARCHAR2(128)       NOT NULL,
    laterality           VARCHAR2(32)        NOT NULL,
    measurement          DOUBLE PRECISION    NOT NULL,
    measurementType      VARCHAR2(128)        DEFAULT 'volume' NOT NULL,
    unit                 VARCHAR2(64)         DEFAULT 'mm^3' NOT NULL,
    owner                NUMBER(38, 0)       NOT NULL,
    modTime              DATE                NOT NULL,
    modUser              NUMBER(38, 0)       NOT NULL,
    ontologySource       VARCHAR2(128)       NOT NULL,
    conceptID            VARCHAR2(64)        NOT NULL,
    extensionName        VARCHAR2(128)        DEFAULT 'brainSegmentData' NOT NULL,
    dataURI              VARCHAR2(2048),
    isRaw                NUMBER(1, 0)         DEFAULT 0 NOT NULL,
    measurementSystem    VARCHAR2(128),
    uniqueID             NUMBER(38, 0),
    isBad                NUMBER(1, 0)         DEFAULT 0 NOT NULL,
    CHECK (laterality IN ('left', 'right', 'n/a')),
    CONSTRAINT nc_brainSegmentData_pk PRIMARY KEY (dataID)
 		USING INDEX
 		(CREATE INDEX nc_brainSegmentData_pidx on nc_brainSegmentData(dataID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_brainSegmentData_sk  UNIQUE (dataID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_brainSegmentData_sidx on nc_brainSegmentData(dataID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_brainSegmentData.dataID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_brainSegmentData.tableID IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_brainSegmentData.segmentID IS 'The sequential ID of the visit segment. For example during a scanning visit each scan would be sequentially numbered.'
;
COMMENT ON COLUMN nc_brainSegmentData.componentID IS 'The sequenceID domain is used to define an ordered sequence of entries or objects (e.g. visits by a subject).  The sequence begins with 1.'
;
COMMENT ON COLUMN nc_brainSegmentData.nc_experimentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_brainSegmentData.subjectID IS 'The investigator ID for the research subject.'
;
COMMENT ON COLUMN nc_brainSegmentData.brainRegionName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_brainSegmentData.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_brainSegmentData.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_brainSegmentData.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_brainSegmentData.ontologySource IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_brainSegmentData.conceptID IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_brainSegmentData.extensionName IS 'The extensionName column is used in inheritance hierarchies to name the object (i.e. the table) a tuple is associated with.  This should default to the name of the table.'
;
COMMENT ON COLUMN nc_brainSegmentData.dataURI IS 'The URI column references the object being described by the tuple.  For data objects, for example, The URI can reference either an individual object (e.g. file or document) or an entire collection (e.g. directory of DICOM images).  

A Uniform Resource Identifier (URI) is a compact sequence of characters that identifies an abstract or physical resource.  The standard for URIs can be found at: http://www.ietf.org/rfc/rfc3986.txt'
;
COMMENT ON COLUMN nc_brainSegmentData.isRaw IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_brainSegmentData.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_brainSegmentData.isBad IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
