DROP TABLE nc_databaseColumn CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_databaseColumn 
--

CREATE TABLE nc_databaseColumn(
    columnName      VARCHAR2(200)    NOT NULL,
    tableName       VARCHAR2(200)    NOT NULL,
    parentColumn    VARCHAR2(200),
    tableID         NUMBER(38, 0)    NOT NULL,
    uniqueID        NUMBER(38, 0)    NOT NULL,
    owner           NUMBER(38, 0)    NOT NULL,
    modTime         DATE             NOT NULL,
    modUser         NUMBER(38, 0)    NOT NULL,
    description     CLOB,
    CONSTRAINT nc_databaseColumn_pk PRIMARY KEY (columnName)
 		USING INDEX
 		(CREATE INDEX nc_databaseColumn_pidx on nc_databaseColumn(columnName)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_databaseColumn_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_databaseColumn_sidx on nc_databaseColumn(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_databaseColumn.columnName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_databaseColumn.tableName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_databaseColumn.parentColumn IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_databaseColumn.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_databaseColumn.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_databaseColumn.owner IS 'The owner column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who owns the data (owner) in a tuple (e.g. the prinicipal investigator of a project who leads the experiment) and who actually entered the data (modUser) in the tuple (e.g. the PI''s graduate student researcher).'
;
COMMENT ON COLUMN nc_databaseColumn.modTime IS 'The modTimecolumn is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who entered the data (modUser) and when (modTime).  Taken together with a core table (nc_TABLENAME) and its backing table (bk_TABLENAME which is used to store the history of changes to a tuple) modTime allows one to fully recreate the history of every tuple stored in a core table.'
;
COMMENT ON COLUMN nc_databaseColumn.modUser IS 'The modUser column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the owner column these two columns specify who owns the data (owner) in a tuple (e.g. the prinicipal investigator of a project who leads the experiment) and who actually entered the data (modUser) in the tuple (e.g. the PI''s graduate student researcher).'
;
COMMENT ON COLUMN nc_databaseColumn.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
