CREATE FUNCTION nc_expcondition_ins_upd() RETURNS trigger AS '
BEGIN
     new.uniqueid := new.expmanipulationid; 
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_expcondition_ins_upd   before insert or update on nc_expcondition  for each row   EXECUTE PROCEDURE nc_expcondition_ins_upd();

CREATE FUNCTION nc_expcondition_insert() RETURNS trigger AS '
BEGIN
  insert into nc_expmanipulation
    (uniqueid, tableid, owner,
     modtime, moduser,extensionname, ontologysource,
     conceptid)
   values(
    new.expmanipulationid,
    new.tableid,
    new.owner,
    new.modtime,
    new.moduser,
    new.extensionname,
    new.ontologysource,
    new.conceptid
   );
   return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_expcondition_insert  after insert on nc_expcondition  for each row  EXECUTE PROCEDURE nc_expcondition_insert();

CREATE FUNCTION nc_expcondition_update() RETURNS trigger AS '
BEGIN
  update nc_expmanipulation
     set 
       tableid = new.tableid,
       owner = new.owner,
       modtime = new.modtime,
       moduser = new.moduser,
       extensionname = new.extensionname,
       ontologysource = new.ontologysource,
       conceptid = new.conceptid
   where 
     uniqueid = new.expmanipulationid;
   return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_expcondition_update  after update on nc_expcondition  for each row  EXECUTE PROCEDURE nc_expcondition_update();

CREATE FUNCTION nc_expcondition_delete() RETURNS trigger AS '
BEGIN
 delete from nc_expmanipulation
 where 
   uniqueid = old.expmanipulationid;
 return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_expcondition_delete  after delete on nc_expcondition  for each row  EXECUTE PROCEDURE nc_expcondition_delete();

