\i create_tables.sql
\i create_triggers.sql

\i SP/sp_user.sql
\i SP/create_static_data.sql
\i SP/sp_create_rater.sql

drop sequence uid_seq;
create sequence uid_seq start with 1;

create or replace function prepare_db(varchar, varchar, 
     varchar, varchar, varchar, varchar, 
     varchar, varchar) returns integer as '
declare
   database_user_name_in ALIAS for $1;
   first_name_in ALIAS for $2;
   last_name_in alias for $3;
   email_in alias for $4;
   rater_name_in alias for $5;
   rater_first_name_in alias for $6; 
   rater_last_name_in alias for $7;
   rater_email_in alias for $8;
   owner_id integer;
   ret_code integer;
BEGIN
  owner_id := create_static_data(database_user_name_in, first_name_in,
                  last_name_in, email_in);
  ret_code := create_rater(rater_name_in, rater_first_name_in, 
               rater_last_name_in, rater_email_in, owner_id);

  return ret_code;
END;
' LANGUAGE plpgsql;


-- PATCH start

create or replace function set_schemaversion(integer,integer,date,varchar) 
returns integer as '
declare
  major_version_in ALIAS for $1;
  minor_version_in ALIAS for $2;
  release_date_in ALIAS for $3;
  owner_in ALIAS for $4;
  unique_id integer;
  owner_id integer;
  cur CURSOR IS select uniqueid from nc_schemaversion where majorversion = major_version_in and minorversion = minor_version_in;
BEGIN
  open cur;
  fetch cur into unique_id;
  if NOT FOUND then
     owner_id := get_database_user_id(owner_in);
     unique_id = nextval(''uid_seq'');
     insert into nc_schemaversion(majorversion,minorversion,uniqueid,tableid,owner,modtime,moduser,releasedate,description) 
       values(major_version_in, minor_version_in, unique_id, get_table_id(''nc_schemaversion''),
          owner_id, now(), owner_id, release_date_in, NULL);
  end if;   
  close cur;
  return 0;
END;
' LANGUAGE plpgsql;



create or replace function add_admin(varchar,varchar,varchar,varchar) 
returns integer as '
declare
  db_user_name_in ALIAS for $1;
  first_name_in ALIAS for $2;
  last_name_in alias for $3;
  email_in alias for $4;
  owner_id integer;
  person_id integer;
  cur CURSOR IS select uniqueid from nc_databaseuser where name = ''ADMIN'' and isgroup = false; 
BEGIN
   open cur;
   fetch cur into owner_id;
   if FOUND then
     close cur;
     raise notice ''Already has ADMIN databaseuser record!'';
     return 1;
   end if;
   close cur;

   owner_id := get_database_user_id(db_user_name_in);

   person_id := get_person_id(first_name_in, last_name_in, email_in);
   if person_id < 0 then
      person_id := nextval(''uid_seq''); 
      insert into nc_person (UNIQUEID,TABLEID,OWNER,
        MODTIME,MODUSER,FIRST_NAME, LAST_NAME, EMAIL) 
      values(person_id, get_table_id(''nc_person''), owner_id, 
        now(), owner_id, first_name_in, last_name_in, email_in);
   end if;
   insert into nc_databaseuser (uniqueid,name,tableid,owner,modtime,moduser,
   userclass,userstatus, isgroup, personid) 
     values(nextval(''uid_seq''),''ADMIN'', get_table_id(''nc_databaseuser''),
     owner_id, now(), owner_id, get_userclass_id(''admin''),
            get_userstatus_id(''active''), false, person_id);

  return 0;
END;
' LANGUAGE plpgsql;

-- PATCH end
\echo '**************************************************'
\echo 'Some configuration parameters need to be entered before'
\echo 'database schema is prepared for usage.'
\echo ''

\echo 'Please enter the database username (e.g. postgres)'
\set dbuser '\''  `read v; echo $v` '\''
\echo 'Entered dbuser: ' :dbuser 

\echo 'Please enter the contact person last name (e.g. Ozyurt)'
\set lastname '\'' `read v; echo $v` '\''
\echo 'Entered lastname: ' :lastname 

\echo 'Please enter the contact person first name (e.g. Burak)'
\set firstname '\'' `read v; echo $v` '\''
\echo 'Entered lastname: ' :firstname
 
\echo 'Please enter the contact person email address (e.g. iozyurt@ucsd.edu)'
\set email '\'' `read v; echo $v` '\''
\echo 'Entered email: ' :email 


-- IMPORTANT: The database user name is the user that you will use to
-- connect to the database by HID web app (or using JDBC)
-- select prepare_db('postgres', 'Burak', 'Ozyurt', 'iozyurt@ucsd.edu',
--                   'postgres', 'Burak', 'Ozyurt', 'iozyurt@ucsd.edu');

\echo '**** Preparing database ****'
select prepare_db(:dbuser, :firstname, :lastname, :email,
                  :dbuser, :firstname, :lastname, :email);

select add_admin(:dbuser,:firstname,:lastname,:email);

--
-- Foreign Keys
--
\i FK/CreateForeignKeys.sql
\i FK/CreateForeignKeys_2.sql
\i FK/CreateForeignKeys_3.sql
\i FK/CreateForeignKeys_4.sql
\i FK/CreateForeignKeys_5.sql

--
-- static data 
--
\i static_data_project.sql

-- IMPORTANT: the data entered by prepare_static_data_project function
-- is process specific and needs to be customized BEFORE usage
-- the site_name (second argument) must be the name of the site setting up
-- the postgres database
-- The FBIRN site names are
-- Duke
-- BWH
-- MGH
-- UCLA
-- UCI
-- UNM
-- Iowa
-- UMN
-- Yale
-- UCSD

\echo 'IMPORTANT: the data entered by prepare_static_data_project function'
\echo 'is process specific and needs to be customized BEFORE usage'
\echo 'the site_name  must be the name of the site that is setting up'
\echo 'the postgres database'
\echo 'The FBIRN site names are'
\echo ' Duke'
\echo ' BWH'
\echo ' MGH'
\echo ' UCLA'
\echo ' UCI'
\echo ' UNM'
\echo ' Iowa'
\echo ' UMN'
\echo ' Yale'
\echo ' UCSD'

\echo 'Please enter the site name (e.g. UCSD)'
\set sitename '\''  `read v; echo $v` '\''
\echo 'Entered sitename: ' :sitename 

\echo '*** prepararing project specific static data ...'
-- select  prepare_static_data_project('postgres','UCSD');
select  prepare_static_data_project(:dbuser,:sitename);

\i create_indices.sql
\i create_cbfbirn_indices.sql

-- setting the schema version 
-- 

select set_schemaversion(3,0,'2008-08-26','postgres');
\echo 'Done!'
