<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="CommonDicomSRValidationRules.xsl"/>
<xsl:output method="text"/>
<xsl:template match="/DicomStructuredReport">
<xsl:choose>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportContent/container/@sopclass = '1.2.840.10008.5.1.4.1.1.88.11'">
<xsl:text>Found BasicTextSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: BasicTextSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="BasicTextSRContentItemConstraints"/>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportContent/container/@sopclass = '1.2.840.10008.5.1.4.1.1.88.22'">
<xsl:text>Found EnhancedSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: EnhancedSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedSRContentItemConstraints"/>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportContent/container/@sopclass = '1.2.840.10008.5.1.4.1.1.88.33'">
<xsl:text>Found ComprehensiveSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: ComprehensiveSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ComprehensiveSRContentItemConstraints"/>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportContent/container/@sopclass = '1.2.840.10008.5.1.4.1.1.88.40'">
<xsl:text>Found ProcedureLog IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: ProcedureLogContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ProcedureLogContentItemConstraints"/>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportContent/container/@sopclass = '1.2.840.10008.5.1.4.1.1.88.50'">
<xsl:text>Found MammographyCADSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: MammographyCADSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MammographyCADSRContentItemConstraints"/>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportContent/container/@sopclass = '1.2.840.10008.5.1.4.1.1.88.59'">
<xsl:text>Found KeyObjectSelectionDocument IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: KeyObjectSelectionDocumentContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="KeyObjectSelectionDocumentContentItemConstraints"/>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportContent/container/@sopclass = '1.2.840.10008.5.1.4.1.1.88.65'">
<xsl:text>Found ChestCADSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: ChestCADSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ChestCADSRContentItemConstraints"/>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportContent/container/@sopclass = '1.2.840.10008.5.1.4.1.1.88.67'">
<xsl:text>Found XRayRadiationDoseSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: XRayRadiationDoseSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="XRayRadiationDoseSRContentItemConstraints"/>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:apply-templates/>
</xsl:when>
<xsl:otherwise>
<xsl:text>IOD (SOP Class) unrecognized</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<xsl:template match="/DicomStructuredReport/DicomStructuredReportHeader">
<xsl:apply-templates/>
</xsl:template>
<xsl:template match="text()"/>
<xsl:template name="BasicTextSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//waveform">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//date">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//time">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="EnhancedSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//waveform">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//date">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//time">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//scoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//tcoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="ComprehensiveSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//waveform">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//date">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//time">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//scoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//tcoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="ProcedureLogContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//date">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//time">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//waveform">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="MammographyCADSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//scoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="KeyObjectSelectionDocumentContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="ChestCADSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//waveform">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//scoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//tcoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and 'T' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="XRayRadiationDoseSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and '' = 'T' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
</xsl:stylesheet>
