#
# ScriptedExtension GUI Procs
# - the 'this' argument to all procs is a vtkScriptedModuleGUI
#

proc ScriptedExtensionConstructor {this} {
}

proc ScriptedExtensionDestructor {this} {
}

proc ScriptedExtensionTearDownGUI {this} {


  # nodeSelector  ;# disabled for now
  set widgets {
    run volumesSelect
    volumesOutputSelect volumesFrame 
  }

  foreach w $widgets {
    $::ScriptedExtension($this,$w) SetParent ""
    $::ScriptedExtension($this,$w) Delete
  }

  if { [[$this GetUIPanel] GetUserInterfaceManager] != "" } {
    set pageWidget [[$this GetUIPanel] GetPageWidget "ScriptedExtension"]
    [$this GetUIPanel] RemovePage "ScriptedExtension"
  }

  unset ::ScriptedExtension(singleton)

}

proc ScriptedExtensionBuildGUI {this} {

  if { [info exists ::ScriptedExtension(singleton)] } {
    error "ScriptedExtension singleton already created"
  }
  set ::ScriptedExtension(singleton) $this

  #
  # create and register the node class
  # - since this is a generic type of node, only do it if 
  #   it hasn't already been done by another module
  #

  set mrmlScene [[$this GetLogic] GetMRMLScene]
  set tag [$mrmlScene GetTagByClassName "vtkMRMLScriptedModuleNode"]
  if { $tag == "" } {
    set node [vtkMRMLScriptedModuleNode New]
    $mrmlScene RegisterNodeClass $node
    $node Delete
  }


  $this SetCategory "Demonstration"
  [$this GetUIPanel] AddPage "ScriptedExtension" "ScriptedExtension" ""
  set pageWidget [[$this GetUIPanel] GetPageWidget "ScriptedExtension"]

  #
  # help frame
  #
  set helptext "The ScriptedExtension shows the framework for creating a scripted module in Tcl.\nThis example is like the ScriptedModuleExample, but it is hosted outside of the slicer source tree and is available for download as an extension."
  set abouttext "This work is supported by NA-MIC, NAC, BIRN, NCIGT, and the Slicer Community. See <a>http://www.slicer.org</a> for details."
  $this BuildHelpAndAboutFrame $pageWidget $helptext $abouttext


  #
  # ScriptedExtension Volumes
  #
  set ::ScriptedExtension($this,volumesFrame) [vtkSlicerModuleCollapsibleFrame New]
  $::ScriptedExtension($this,volumesFrame) SetParent $pageWidget
  $::ScriptedExtension($this,volumesFrame) Create
  $::ScriptedExtension($this,volumesFrame) SetLabelText "Volumes"
  pack [$::ScriptedExtension($this,volumesFrame) GetWidgetName] \
    -side top -anchor nw -fill x -padx 2 -pady 2 -in [$pageWidget GetWidgetName]

  set ::ScriptedExtension($this,volumesSelect) [vtkSlicerNodeSelectorWidget New]
  $::ScriptedExtension($this,volumesSelect) SetParent [$::ScriptedExtension($this,volumesFrame) GetFrame]
  $::ScriptedExtension($this,volumesSelect) Create
  $::ScriptedExtension($this,volumesSelect) SetNodeClass "vtkMRMLScalarVolumeNode" "" "" ""
  $::ScriptedExtension($this,volumesSelect) SetMRMLScene [[$this GetLogic] GetMRMLScene]
  $::ScriptedExtension($this,volumesSelect) UpdateMenu
  $::ScriptedExtension($this,volumesSelect) SetLabelText "Source Volume:"
  $::ScriptedExtension($this,volumesSelect) SetBalloonHelpString "The Source Volume to operate on"
  pack [$::ScriptedExtension($this,volumesSelect) GetWidgetName] -side top -anchor e -padx 2 -pady 2 

  set ::ScriptedExtension($this,volumesOutputSelect) [vtkSlicerNodeSelectorWidget New]
  $::ScriptedExtension($this,volumesOutputSelect) SetParent [$::ScriptedExtension($this,volumesFrame) GetFrame]
  $::ScriptedExtension($this,volumesOutputSelect) Create
  $::ScriptedExtension($this,volumesOutputSelect) NewNodeEnabledOn
  $::ScriptedExtension($this,volumesOutputSelect) SetNodeClass "vtkMRMLScalarVolumeNode" "" "" ""
  $::ScriptedExtension($this,volumesOutputSelect) SetMRMLScene [[$this GetLogic] GetMRMLScene]
  $::ScriptedExtension($this,volumesOutputSelect) UpdateMenu
  $::ScriptedExtension($this,volumesOutputSelect) SetLabelText "Output Volume:"
  $::ScriptedExtension($this,volumesOutputSelect) SetBalloonHelpString "The target output volume"
  pack [$::ScriptedExtension($this,volumesOutputSelect) GetWidgetName] -side top -anchor e -padx 2 -pady 2 

  set ::ScriptedExtension($this,run) [vtkKWPushButton New]
  $::ScriptedExtension($this,run) SetParent [$::ScriptedExtension($this,volumesFrame) GetFrame]
  $::ScriptedExtension($this,run) Create
  $::ScriptedExtension($this,run) SetText "Apply"
  $::ScriptedExtension($this,run) SetBalloonHelpString "Apply algorithm."
  pack [$::ScriptedExtension($this,run) GetWidgetName] -side top -anchor e -padx 2 -pady 2 

}

proc ScriptedExtensionAddGUIObservers {this} {
  $this AddObserverByNumber $::ScriptedExtension($this,run) 10000 
    
  $this AddMRMLObserverByNumber [[[$this GetLogic] GetApplicationLogic] GetSelectionNode] 31
    
}

proc ScriptedExtensionRemoveGUIObservers {this} {
  $this RemoveMRMLObserverByNumber [[[$this GetLogic] GetApplicationLogic] GetSelectionNode] 31
}

proc ScriptedExtensionRemoveLogicObservers {this} {
}

proc ScriptedExtensionRemoveMRMLNodeObservers {this} {
}

proc ScriptedExtensionProcessLogicEvents {this caller event} {
}

proc ScriptedExtensionProcessGUIEvents {this caller event} {
  
  if { $caller == $::ScriptedExtension($this,run) } {
    switch $event {
      "10000" {
        ScriptedExtensionApply $this
      }
    }
  } 

  ScriptedExtensionUpdateMRML $this
}

#
# Accessors to ScriptedExtension state
#


# get the ScriptedExtension parameter node, or create one if it doesn't exist
proc ScriptedExtensionCreateParameterNode {} {
  set node [vtkMRMLScriptedModuleNode New]
  $node SetModuleName "ScriptedExtension"

  # set node defaults
  $node SetParameter label 1

  $::slicer3::MRMLScene AddNode $node
  $node Delete
}

# get the ScriptedExtension parameter node, or create one if it doesn't exist
proc ScriptedExtensionGetParameterNode {} {

  set node ""
  set nNodes [$::slicer3::MRMLScene GetNumberOfNodesByClass "vtkMRMLScriptedModuleNode"]
  for {set i 0} {$i < $nNodes} {incr i} {
    set n [$::slicer3::MRMLScene GetNthNodeByClass $i "vtkMRMLScriptedModuleNode"]
    if { [$n GetModuleName] == "ScriptedExtension" } {
      set node $n
      break;
    }
  }

  if { $node == "" } {
    ScriptedExtensionCreateParameterNode
    set node [ScriptedExtensionGetParameterNode]
  }

  return $node
}


proc ScriptedExtensionGetLabel {} {
  set node [ScriptedExtensionGetParameterNode]
  if { [$node GetParameter "label"] == "" } {
    $node SetParameter "label" 1
  }
  return [$node GetParameter "label"]
}

proc ScriptedExtensionSetLabel {index} {
  set node [ScriptedExtensionGetParameterNode]
  $node SetParameter "label" $index
}

#
# MRML Event processing
#

proc ScriptedExtensionUpdateMRML {this} {
}

proc ScriptedExtensionProcessMRMLEvents {this callerID event} {

    set caller [[[$this GetLogic] GetMRMLScene] GetNodeByID $callerID]
    if { $caller == "" } {
        return
    }
}

proc ScriptedExtensionEnter {this} {
}

proc ScriptedExtensionExit {this} {
}

proc ScriptedExtensionApply {this} {

  set dialog [vtkKWMessageDialog New]
  $dialog SetParent [$::slicer3::ApplicationGUI GetMainSlicerWindow]
  $dialog SetMasterWindow [$::slicer3::ApplicationGUI GetMainSlicerWindow]
  $dialog SetStyleToMessage
  $dialog SetText "Perform action here..."
  $dialog Create
  $dialog Invoke
  $dialog Delete
}
