function eventdata = setEventData(h,eventdata)


%  setEventData(h,evtdata)
%
% Associates the evtdata with current data set
% and/or brings up the event data window
%
% evtdata is a structure returned by MAKEEVENTDATA
%
% See also MAKEEVENTDATA

% ----------- SVN REVISION INFO ------------------
% $URL: file:///var/lib/gforge/svnroot/gazereader/0.1/setEventData.m $
% $Revision: 51 $
% $Date: 2011-04-19 17:17:26 -0400 (Tue, 19 Apr 2011) $
% $Author: ckovach $
% ------------------------------------------------



if nargin < 1 || isempty(h) || ~ishandle(h)    
    h = GazeReader;
end



if nargin > 1
    setappdata(h,'expEventData',eventdata);
elseif nargout > 0
    eventdata = getappdata(h,'expEventData');
end

handles = guidata(h);

GazeReader('EventManager_Callback',h,[],handles); %Initialize events

emfun = getappdata(h,'EventManagerFunctions');
tmfun = getappdata(h,'trialManagerFunctions');

if ~isempty(emfun)
    emfun.updateAllTrials();
end

if ~isempty(tmfun)
    tmfun.updateAllDataSets();
end
