% ----------- SVN REVISION INFO ------------------
% $URL: file:///var/lib/gforge/svnroot/gazereader/0.1/cdf_point_transform.m $
% $Revision: 45 $
% $Date: 2011-04-18 12:53:38 -0400 (Mon, 18 Apr 2011) $
% $Author: ckovach $
% ------------------------------------------------


function Xtrans = pdf_point_transform(PDF,X)


if length(PDF) > 2 || min(size(PDF)) > 1
    
    prx = cumsum(sum(PDF));
    pry = cumsum(sum(PDF,2))';
else
    prx = cumsum(PDF);
    pry = 1;
end
nx = length(prx);
ny = length(pry);
npt = size(X,1);

dx = repmat(X(:,1),1,nx) - repmat(prx,npt,1);
dy = repmat(X(:,2),1,ny) - repmat(pry,npt,1);


[mnx,mnxi] = min(abs(dx),[],2);    
[mny,mnyi] = min(abs(dy),[],2);

Xtrans = [mnxi,mnyi];

