function importData(h,datafiles,fpath)

%  importData(h,datafiles)
%
% Imports eye-tracker data files. Currently supported file types are Eyelink (*.edf) and ASL (*.asl).
%

% ----------- SVN REVISION INFO ------------------
% $URL: file:///var/lib/gforge/svnroot/gazereader/0.1/importData.m $
% $Revision: 45 $
% $Date: 2011-04-18 12:53:38 -0400 (Mon, 18 Apr 2011) $
% $Author: ckovach $
% ------------------------------------------------

if nargin < 1 || isempty(h) || ~ishandle(h)    
    h = GazeReader;
end

if nargin < 2
    datafiles = [];
elseif ~iscell(datafiles)
    datafiles = {datafiles};
end

if nargin < 3
    fpath = [];
end

handles = guidata(h);

GazeReader('importEyetrackerData_menu_Callback',h,[],handles,datafiles,fpath);