function [R,Th] = lin2rad(X,Y)

%Converts linear XY coordinates to polar coordinates with Th = 0 being
%horizontal up.

% ----------- SVN REVISION INFO ------------------
% $URL: file:///var/lib/gforge/svnroot/gazereader/0.1/lin2rad.m $
% $Revision: 45 $
% $Date: 2011-04-18 12:53:38 -0400 (Mon, 18 Apr 2011) $
% $Author: ckovach $
% ------------------------------------------------

if nargin == 2
    X = [X(:),Y(:)];
end

R = sqrt(sum(X.^2,2));

Th = atan2(X(:,1),X(:,2));