function imdata = loadImages(h,imagefiles,fpath)


%  imdata = loadImages(h,imagefiles,fpath)
%
%  Loads specified image files.
%
%
% See also ImageManager

% ----------- SVN REVISION INFO ------------------
% $URL: file:///var/lib/gforge/svnroot/gazereader/0.1/loadImages.m $
% $Revision: 45 $
% $Date: 2011-04-18 12:53:38 -0400 (Mon, 18 Apr 2011) $
% $Author: ckovach $
% ------------------------------------------------



if nargin < 1 || isempty(h) || ~ishandle(h)    
    h = GazeReader;
end


if nargin < 2
    imagefiles = [];
end
if nargin < 3
    fpath = [];
end


handles = guidata(h);

GazeReader('Image_Manager_Callback',h,[],handles);
imgfun  = getappdata(h,'ImageManagerFunctions');
imgfun.LoadImages(fpath,imagefiles);

if nargout > 0
    imdata = getappdata(h,'imageData');
end

