function [brain,mask,atlasCort,atlasSub,AffMat,Labels] = loadAtlases(Params)

brain = load_nii([Params.PublicParams.maskPath 'MNI152_T1_2mm_brain.nii']);
if ~strcmp(Params.PrivateParams.brainMask(end-2:end),'nii')
    mask = load_nii([Params.PrivateParams.brainMask '.nii']);
else
    mask = load_nii([Params.PrivateParams.brainMask]);    
end
atlasCort = load_nii(Params.PrivateParams.brainAtlases{3});

% generate lateralized cortical brain atlas including left and right
% areas separately:
load cortical_atlas_inds inds
at = zeros(size(atlasCort.img));
for m = 1:length(inds)
    at(inds{m}) = m;
end
atlasCort.img = uint8(at);
% create subcortical atlas:
atlasSub = load_nii(Params.PrivateParams.brainAtlases{4});
load subcortical_atlas_inds inds
at = zeros(size(atlasSub.img));
for m = 1:length(inds)
    at(inds{m}) = m;
end
atlasSub.img = uint8(at);
atlasSub.img(atlasSub.img > 0) = atlasSub.img(atlasSub.img > 0) + 100;

% load brain area labels:
Labels = readtable('atlas_labels_abbr.csv');

AffMat = [atlasCort.hdr.hist.srow_x;
    atlasCort.hdr.hist.srow_y;
    atlasCort.hdr.hist.srow_z; 0 0 0 1];

% testing:
%inv(AffMat)*[0 0 0 1]' + 1
% V = [45 63 36 1]';
