function [results1,results2] = matchClusters(Params1,Params2)

NoiseThres = [inf inf];
NoiseThres = [4000 4000];
maxNrClusters = [inf inf];
smoothingParam = [200 200];

[clust1,X1] = load_files(Params1);
[clust2,X2] = load_files(Params2);

% In the FIRST figure, we always plot the data with higher number of clusters:
nrClust1 = size(clust1.bestMu,1);
nrClust2 = size(clust2.bestMu,1);
if nrClust2 > nrClust1
    ParamsTmp = Params2;
    Params2 = Params1;
    Params1 = ParamsTmp;
%    clust1_tmp = clust1;
%    X1_tmp = X1;    
%    clust1 = clust2;
%    X1 = X2;
%    clust2 = clust1_tmp;
%    X2 = X1_tmp;
%    clear X1_tmp clust1_tmp    
    warning('The second data set contains more clusters than the first, reversing plot order...')
    
end

results1 = plotSegmentationResults(Params1,NoiseThres(1),maxNrClusters(1),smoothingParam(1),[],1);
results2 = plotSegmentationResults(Params2,NoiseThres(2),maxNrClusters(2),smoothingParam(2),[],results1)
set(results1.colbar,'YTickLabel',results2.DiceVals)
