function results = postProcessClusters_ver3(clustRes,brain,atlasCort,atlasSub,Labels,TH,AffMat,CL,find_subclusters)
% Function collects information (size, number of subclusters,
% center of mass, abbreviation, densest point etc.) from each cluster into
% a single structure variable "results".

% Last modified 8.3.2017

%find_subclusters = 0;

Labels.abbreviation(1) = {'FrontPole L'};
Labels.abbreviation(2) = {'FrontPole R'};
Labels.abbreviation(3) = {'Ins L'};
Labels.abbreviation(4) = {'Ins R'};
Labels.abbreviation(5) = {'SFG L'     };
Labels.abbreviation(6) = {'SFG R'     };
Labels.abbreviation(7) = {'MFG L'     };
Labels.abbreviation(8) = {'MFG R'     };
Labels.abbreviation(9) = {'IFGtr L'   };
Labels.abbreviation(10) = {'IFGtr R'   };
Labels.abbreviation(11) = {'IFGop L'   };
Labels.abbreviation(12) = {'IFGop R'   };
Labels.abbreviation(13) = {'PreCentG L' };
Labels.abbreviation(14) = {'PreCentG R'  };
Labels.abbreviation(15) = {'tmp L'  };
Labels.abbreviation(16) = {'tmp R'   };
Labels.abbreviation(17) = {'STGant L' };
Labels.abbreviation(18) = {'STGant R'  };
Labels.abbreviation(19) = {'STGpos L'  };
Labels.abbreviation(20) = {'STGpos R'  };
Labels.abbreviation(21) = {'MTGant L'  };
Labels.abbreviation(22) = {'MTGant R'  };
Labels.abbreviation(23) = {'MTGpos L'  };
Labels.abbreviation(24) = {'MTGpos R'  };
Labels.abbreviation(25) = {'MTGto L'   };
Labels.abbreviation(26) = {'MTGto R'   };
Labels.abbreviation(27) = {'ITGant L'  };
Labels.abbreviation(28) = {'ITGant R'  };
Labels.abbreviation(29) = {'ITGpos L'  };
Labels.abbreviation(30) = {'ITGpos R'  };
Labels.abbreviation(31) = {'ITGto L'   };
Labels.abbreviation(32) = {'ITGto R'   };
Labels.abbreviation(33) = {'PoG L'     };
Labels.abbreviation(34) = {'PoG R'     };
Labels.abbreviation(35) = {'SPL L'     };
Labels.abbreviation(36) = {'SPL R'     };
Labels.abbreviation(37) = {'SMGant L'  };
Labels.abbreviation(38) = {'SMGant R'  };
Labels.abbreviation(39) = {'SupramGpos L'};
Labels.abbreviation(40) = {'SupramGpos R' };
Labels.abbreviation(41) = {'AnG L'     };
Labels.abbreviation(42) = {'AnG R'     };
Labels.abbreviation(43) = {'LOCsup L'  };
Labels.abbreviation(44) = {'LOCsup R'  };
Labels.abbreviation(45) = {'LOCinf L'  };
Labels.abbreviation(46) = {'LOCinf R'  };
Labels.abbreviation(47) = {'intCal L'  };
Labels.abbreviation(48) = {'intCal R'  };
Labels.abbreviation(49) = {'FMC L'     };
Labels.abbreviation(50) = {'FMC R'     };
Labels.abbreviation(51) = {'SMA L'     };
Labels.abbreviation(52) = {'SMA R'     };
Labels.abbreviation(53) = {'SCA L'     };
Labels.abbreviation(54) = {'SCA R'     };
Labels.abbreviation(55) = {'ParaCingC L'};
Labels.abbreviation(56) = {'ParaCingC R' };
Labels.abbreviation(57) = {'ACC L'    };
Labels.abbreviation(58) = {'ACC R'    };
Labels.abbreviation(59) = {'PCgG L'    };
Labels.abbreviation(60) = {'PCgG R'};
Labels.abbreviation(61) = {'PreCun L'};
Labels.abbreviation(62) = {'PreCun R'};
Labels.abbreviation(63) = {'Cuneus L'};
Labels.abbreviation(64) = {'Cuneus R'};
Labels.abbreviation(65) = {'FrOrbC L'};
Labels.abbreviation(66) = {'FrOrbC R'};
Labels.abbreviation(67) = {'PHGant L'};
Labels.abbreviation(68) = {'PHGant R'};
Labels.abbreviation(69) = {'PHGpos L'};
Labels.abbreviation(70) = {'PHGpos R'};
Labels.abbreviation(71) = {'LingualG L'};
Labels.abbreviation(72) = {'LingualG R'};
Labels.abbreviation(73) = {'TFuant L'};
Labels.abbreviation(74) = {'TFuant R'};
Labels.abbreviation(75) = {'TFupos L'};
Labels.abbreviation(76) = {'TFupos R'};
Labels.abbreviation(77) = {'TOFuG L'};
Labels.abbreviation(78) = {'TOFuG R'};
Labels.abbreviation(79) = {'OFuG L'};
Labels.abbreviation(80) = {'OFuG R'};
Labels.abbreviation(81) = {'FOper L'};
Labels.abbreviation(82) = {'FOper R'};
Labels.abbreviation(83) = {'CntrOper L'};
Labels.abbreviation(84) = {'CntrOper R'};
Labels.abbreviation(85) = {'POper L'};
Labels.abbreviation(86) = {'POper R'};
Labels.abbreviation(87) = {'PPolare L'};
Labels.abbreviation(88) = {'PPolare R'};
Labels.abbreviation(89) = {'HeschlG L'};
Labels.abbreviation(90) = {'HeschlG R'    };
Labels.abbreviation(91) = {'PlanTemp L'};
Labels.abbreviation(92) = {'PlanTemp R'};
Labels.abbreviation(93) = {'SupraCalc L'};
Labels.abbreviation(94) = {'SupraCalc R' };
Labels.abbreviation(95) = {'OccipPole L'  };
Labels.abbreviation(96) = {'OccipPole R'   };
Labels.abbreviation(97) = {'cw L'  };
Labels.abbreviation(98) = {'Cx L'   };
Labels.abbreviation(99) = {'LV L'    };
Labels.abbreviation(100) = {'Th L'     };
Labels.abbreviation(101) = {'Cd L'      };
Labels.abbreviation(102) = {'Pu L'      };
Labels.abbreviation(103) = {'GP L'      };
Labels.abbreviation(104) = {'BS'        };
Labels.abbreviation(105) = {'Hpc L'     };
Labels.abbreviation(106) = {'Amg L'     };
Labels.abbreviation(107) = {'Acb L'     };
Labels.abbreviation(108) = {'cw R'      };
Labels.abbreviation(109) = {'cx R'      };
Labels.abbreviation(110) = {'LV R'      };
Labels.abbreviation(111) = {'Th R'     };
Labels.abbreviation(112) = {'Cd R'    };
Labels.abbreviation(113) = {'Pu R'    };
Labels.abbreviation(114) = {'GP R'   };
Labels.abbreviation(115) = {'Hcp R' };
Labels.abbreviation(116) = {'Amg R'};
Labels.abbreviation(117) = {'Acb R'};


atlas_inds = table2array(Labels(:,1))';
idx = clustRes.idx;
clustRes.idx = idx;
k = clustRes.SNN.k;
nn_dists = clustRes.KNN.nearestNeighborDists;

brain.img = double(brain.img);
brain_ind = find(brain.img(:));
brain.img(find(brain.img)) = 1;
index_table = [(1:length(brain_ind))' brain_ind];

% find brain voxels:
brain_voxels = clustRes.brainVoxels;

atlasAll = atlasSub.img;
atlasAll(atlasCort.img>0) = atlasCort.img(atlasCort.img>0);

% set clusters over anatomical image:
brainsize = size(brain.img);

% map the results back to the spatial domain:
result = zeros(brainsize);
result(brain_voxels) = idx;
%result(brain_voxels)=idx;

% for each cluster m, find their subclusters:
clear clustCent clustInd densestPoint com densest_point densest_point_orig
L = unique(nonzeros(result));
densest_point = NaN*zeros(max(L),10000);
com = NaN*zeros(max(L),10000);
densest_point_orig = NaN*zeros(max(L),10000);
densest_point_val = NaN*zeros(max(L),10000);
c_mass = NaN*zeros(max(L),10000);
sub_clust_size = NaN*zeros(max(L),10000);
subcort_densest = NaN*zeros(max(L),10000);
cort_densest = NaN*zeros(max(L),10000);
subcort_com = NaN*zeros(max(L),10000);
cort_com = NaN*zeros(max(L),10000);

%TH = 10 % threshold to remove too small spatial regions, this could correspond to k.
results.index_table = index_table;

for m = 1:length(L)
    tic
    disp(['Extracting information for cluster: ' num2str(m) '/' num2str(length(L))])
    BW = result == L(m);
    if find_subclusters
        CC = bwconncomp(BW);
        c_mass = regionprops(CC,'Centroid');
        c_area = regionprops(CC,'Area');
        c_area = arrayfun(@(x) x.Area,c_area)';
        [c_area,c_area_ind] = sort(c_area,'descend');
        CC.PixelIdxList = CC.PixelIdxList(c_area_ind);
    else
        CC.PixelIdxList{1} = find(BW);
        fi = find(BW);
        [xx,yy,zz] = ind2sub(size(BW),fi);
        cent = [mean(xx) mean(yy) mean(zz)];
        mi = sum(abs([xx yy zz] - repmat(cent,length(xx),1)),2);
        [mi2,mii] = min(mi);
        Ce = [xx(mii),yy(mii),zz(mii)];
    end
    results.clustInd{m} = find(BW);
    for n = 1:length(CC.PixelIdxList) % tee jokaiselle aliklusterille < TH:
        if ( n == 1 ) || ( length(CC.PixelIdxList{n}) >= TH )
            results.subclusters{m}{n} = CC.PixelIdxList{n};
            % hae aivojen sisn osuvien vokselien indeksi:
            [I,i1] = intersect(brain_voxels,CC.PixelIdxList{n});
            sub_clust_size(m,n) = length(i1);
            % densest point according to the number of k-nearest neighbors:
            knn_densities = nn_dists(i1,min(sub_clust_size(m,n),k));
            [mi,mii] = min(knn_densities);
            densest_point = i1(mii);
            results.densest_point3{m,n} = [clustRes.KNN.nearestNeighborInds(densest_point,1:k)];
            results.densest_point2(m,n) = index_table(densest_point,2);
            results.densest_point(m,n) = i1(mii);
            densest_point(m,n) = index_table(densest_point,2);
            results.densest_point_val(m,n) = mi;
            % transform it to corresponding MNI coordinate:
            [x,y,z] = ind2sub(size(brain.img),densest_point(m,n));
            VoxCoord = [x-1;y-1;z-1;1];
            MNI_densest =  AffMat*VoxCoord;
            results.MNI_densest{m,n} = round(MNI_densest(1:3)*10)/10;
            % find brain area corresponding to densest point:
            alue_index = atlasAll(densest_point(m,n));
            if alue_index == 0 | alue_index == 102 | alue_index == 113
                results.alue_densest{m,n} = {' '};
                results.alue_densest_abbr{m,n} = {' '};
            else
                results.alue_densest{m,n} = Labels(find(atlas_inds == alue_index),3).label;
                results.alue_densest_abbr{m,n} = Labels(find(atlas_inds == alue_index),4).abbreviation;
            end
            if find_subclusters
            % find center of mass (COM):        
                Ce = round(c_mass(c_area_ind(n)).Centroid([2 1 3]));
            end
            siz = size(BW);
            com(m,n) = sub2ind(siz, Ce(1), Ce(2), Ce(3));
            % transform it to corresponding MNI coordinate:
            [x,y,z] = ind2sub(siz,com(m,n));
            VoxCoord = [x-1;y-1;z-1;1];
            MNI_com =  AffMat*VoxCoord;
            results.MNI_com{m,n} = round(MNI_com(1:3)*10)/10;
            results.com(m,n) = com(m,n);
            % find name of the brain area corresponding to COM:
            alue_index = atlasAll(com(m,n));
            if (find(atlas_inds == alue_index) == 0) | (find(atlas_inds == alue_index) == 102) | (find(atlas_inds == alue_index) == 113) | (find(atlas_inds == alue_index) == 108) | ...
                    (find(atlas_inds == alue_index) == 109) | (find(atlas_inds == alue_index) == 110) | (find(atlas_inds == alue_index) == 108) | (find(atlas_inds == alue_index) == 97) | ...
                    (find(atlas_inds == alue_index) == 98) | (find(atlas_inds == alue_index) == 99)
                results.alue_com{m,n} = {' '};
                results.alue_com_abbr{m,n} = {' '};
            else
                results.alue_com{m,n} = Labels(find(atlas_inds == alue_index),3).label;
                results.alue_com_abbr{m,n} = Labels(find(atlas_inds == alue_index),4).abbreviation;
            end
                        
            aliklusterin_aivoalueet_cort = atlasCort.img(index_table(i1,2));
            aliklusterin_aivoalueet_full = atlasAll(index_table(i1,2));
            alueindeksi_cort = unique(double(aliklusterin_aivoalueet_cort));
            alueindeksi_full = unique(double(aliklusterin_aivoalueet_full));
            if length(alueindeksi_cort) > 1
                hist_counts_cort = hist(double(aliklusterin_aivoalueet_cort),alueindeksi_cort);
            else
                hist_counts_cort = length(aliklusterin_aivoalueet_cort);
            end
            if length(alueindeksi_full) > 1
                hist_counts_full = hist(double(aliklusterin_aivoalueet_full),alueindeksi_full);
            else
                hist_counts_full = length(aliklusterin_aivoalueet_full);
            end
            poista_cort = find(alueindeksi_cort == 0);
            poista_full = find(alueindeksi_full == 0 | alueindeksi_full == 102 | alueindeksi_full == 113);
            alueindeksi_cort(poista_cort) = NaN;
            alueindeksi_full(poista_full) = NaN;
            [hist_counts_cort,sind] = sort(hist_counts_cort,'descend');
            alueindeksi_cort = alueindeksi_cort(sind);
            [hist_counts_full,sind] = sort(hist_counts_full,'descend');
            alueindeksi_full = alueindeksi_full(sind);
            for mm = 1:length(alueindeksi_full)
                if ~isnan(alueindeksi_full(mm))
                    results.all_regions{m,n}(mm,:) = Labels(find(atlas_inds == alueindeksi_full(mm)),3).label;
                    results.all_regions_abbr{m,n}(mm,:) = Labels(find(atlas_inds == alueindeksi_full(mm)),4).abbreviation;
                    results.all_nrvox{m,n}(mm,:) = hist_counts_full(mm);
                else
                    results.all_regions{m,n}(mm,:) = {' '};
                    results.all_regions_abbr{m,n}(mm,:) = {' '};
                    results.all_nrvox{m,n}(mm,:) = hist_counts_full(mm);
                end
            end
            for mm = 1:length(alueindeksi_cort)
                if ~isnan(alueindeksi_cort(mm))
                    results.cort_regions{m,n}(mm,:) = Labels(find(atlas_inds == alueindeksi_cort(mm)),3).label;
                    results.cort_regions_abbr{m,n}(mm,:) = Labels(find(atlas_inds == alueindeksi_cort(mm)),4).abbreviation;
                    results.cort_nrvox{m,n}(mm,:) = hist_counts_cort(mm);
                else
                    results.cort_regions{m,n}(mm,:) = {' '};
                    results.cort_regions_abbr{m,n}(mm,:) = {' '};
                    results.cort_nrvox{m,n}(mm,:) = hist_counts_cort(mm);
                end
            end
        end
    end
end

nrNames = 2;
for m = 1:size(results.MNI_com,1)
    clustNames_abbr{m,1} = [];
    clustNames_abbr2{m,1} = [];
    clustNames_full{m,1} = [];
    P = 0;
    for n = 1:size(results.MNI_com,2)
        if ~isempty(results.alue_com{m,n})
            if P == 0
                vm = '';
            else
                vm = ', ';
            end
            alue_full = results.alue_com{m,n}{1};
            alue_abbr = results.alue_com_abbr{m,n}{1};
            if ~strcmp(alue_full, ' ')
                clustNames_abbr{m} = [clustNames_abbr{m} vm alue_abbr];
                clustNames_full{m,P+1} = [alue_full];% ' (' alue_abbr ')'];
                clustNames_abbr2{m,P+1} = [alue_abbr];
                P = P + 1;
            else
                for v = 1:length(results.cort_regions{m,n})
                    alue_full = results.cort_regions{m,n}{v};
                    alue_abbr = results.cort_regions_abbr{m,n}{v};
                    if ~strcmp(alue_full,' ')
                        clustNames_abbr{m} = [clustNames_abbr{m} vm alue_abbr];
                        clustNames_full{m,P+1} = [alue_full];% ' (' alue_abbr ')'];
                        clustNames_abbr2{m,P+1} = [alue_abbr];
                        P = P + 1;
                        break
                    end
                end
            end
        end
        if nrNames == P
            break
        end
    end
    if isempty(clustNames_full{m})
        clustNames_full{m} = 'unspecified';
        clustNames_abbr{m} = 'unspecified';
        clustNames_abbr2{m} = 'unspecified';
    end
end

results.clustNames_full = clustNames_full;
results.clustNames_abbr2 = clustNames_abbr2;
results.clustNames_abbr = clustNames_abbr;

