function varargout = FuSeSettings(varargin)
% FUSESETTINGS MATLAB code for FuSeSettings.fig
%      FUSESETTINGS, by itself, creates a new FUSESETTINGS or raises the existing
%      singleton*.
%
%      H = FUSESETTINGS returns the handle to a new FUSESETTINGS or the handle to
%      the existing singleton*.
%
%      FUSESETTINGS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FUSESETTINGS.M with the given input arguments.
%
%      FUSESETTINGS('Property','Value',...) creates a new FUSESETTINGS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before FuSeSettings_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to FuSeSettings_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help FuSeSettings

% Last Modified by GUIDE v2.5 15-Jan-2017 21:31:00

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @FuSeSettings_OpeningFcn, ...
                   'gui_OutputFcn',  @FuSeSettings_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before FuSeSettings is made visible.
function FuSeSettings_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to FuSeSettings (see VARARGIN)

handles.Pub = varargin{1};

%set functions
set(handles.FuSe_K,'String',num2str(handles.Pub.FuSe_K));

if handles.Pub.FuSe_multiK
    set(handles.FuSe_minK,'Enable','on')
    set(handles.FuSe_stepK,'Enable','on')
    set(handles.FuSe_maxK,'Enable','on')
    set(handles.FuSe_K,'Enable','off')
    set(handles.FuSe_minK,'String',num2str(handles.Pub.FuSe_minK));
    set(handles.FuSe_stepK,'String',num2str(handles.Pub.FuSe_stepK));
    set(handles.FuSe_maxK,'String',num2str(handles.Pub.FuSe_maxK));
else
    set(handles.FuSe_K,'Enable','on')
    set(handles.FuSe_minK,'Enable','off')
    set(handles.FuSe_stepK,'Enable','off')
    set(handles.FuSe_maxK,'Enable','off')
end

if handles.Pub.FuSe_mask
    set(handles.FuSeMaskPath,'Enable','on')
    set(handles.FuSeMaskPath,'String',handles.Pub.FuSeMaskPath);
else
    set(handles.FuSeMaskPath,'Enable','off')    
end

set(handles.Fuse_Diag,'Value',handles.Pub.FuSe_Diag);
set(handles.FuSe_Set,'Value',handles.Pub.FuSe_FSet);
set(handles.FuSe_reg,'Value',handles.Pub.FuSe_reg_opt);
set(handles.FuSe_remove_temp,'Value',handles.Pub.FuSe_remove_temp);
set(handles.FuSe_mask,'Value',handles.Pub.FuSe_mask);
set(handles.FuSe_multiK,'Value',handles.Pub.FuSe_multiK);

% Choose default command line output for FuSeSettings
handles.output = handles.Pub;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes FuSeSettings wait for user response (see UIRESUME)
uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = FuSeSettings_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
if(isfield(handles, 'output'))
    varargout{1} = handles.output;
    delete(handles.figure1)
else
    varargout{1} = [];
end


function FuSe_K_Callback(hObject, eventdata, handles)
% hObject    handle to FuSe_K (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of FuSe_K as text
%        str2double(get(hObject,'String')) returns contents of FuSe_K as a double
Kstr = get(hObject,'String');
handles.Pub.FuSe_K = str2double(Kstr);
disp(['FuSe neighbourghood k = ' Kstr])
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function FuSe_K_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FuSe_K (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in FuSe_Set.
function FuSe_Set_Callback(hObject, eventdata, handles)
% hObject    handle to FuSe_Set (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns FuSe_Set contents as cell array
%        contents{get(hObject,'Value')} returns selected item from FuSe_Set
Fstr =get(hObject,'Value');
handles.Pub.FuSe_FSet = Fstr;
disp(['FuSe Feature set ' num2str(Fstr) ' selected'])
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function FuSe_Set_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FuSe_Set (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Fuse_Diag.
function Fuse_Diag_Callback(hObject, eventdata, handles)
% hObject    handle to Fuse_Diag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Fuse_Diag
val = get(hObject,'Value');
handles.Pub.FuSe_Diag = val;
if val
    disp('Using diagonal covariance matrices in the GMM')
else
    disp('Using full covariance matrices in the GMM')
end
if handles.Pub.FuSe_Diag
    handles.Pub.FuSe_reg_opt = false; %default, but possible to change
    set(handles.FuSe_reg,'Value',false);
    set(handles.FuSe_reg,'Enable','on')  
else
    handles.Pub.FuSe_reg_opt = true; %forced default, regularisation needed with full matrices
    set(handles.FuSe_reg,'Enable','off')  
    set(handles.FuSe_reg,'Value',true);
end
set(handles.FuSe_reg,'Value',handles.Pub.FuSe_reg_opt);

guidata(hObject, handles);

% --- Executes on button press in FuSe_reg.
function FuSe_reg_Callback(hObject, eventdata, handles)
% hObject    handle to FuSe_reg (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of FuSe_reg
val = get(hObject,'Value');
handles.Pub.FuSe_reg_opt = val;
if val
    disp('Using Regularization in FuSe clustering')
else
    disp('Using no Regularization in FuSe clustering')
end

guidata(hObject, handles);

% --- Executes on button press in pushbutton_Select.
function pushbutton_Select_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Select (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.output = handles.Pub;
guidata(hObject, handles);
uiresume(handles.figure1)

% --- Executes on button press in pushbutton_Cancel.
function pushbutton_Cancel_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Cancel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
uiresume(handles.figure1)


% --- Executes on button press in FuSe_remove_temp.
function FuSe_remove_temp_Callback(hObject, eventdata, handles)
% hObject    handle to FuSe_remove_temp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Hint: get(hObject,'Value') returns toggle state of FuSe_reg
val = get(hObject,'Value');
handles.Pub.FuSe_remove_temp = val;
if val
    disp('Selected FuSe temporary files removal after analysis.')
else
    disp('Selected to save FuSe temporary files for future use after analysis.')
end

guidata(hObject, handles);
% Hint: get(hObject,'Value') returns toggle state of FuSe_remove_temp


% --- Executes on button press in FuSe_mask.
function FuSe_mask_Callback(hObject, eventdata, handles)
% hObject    handle to FuSe_mask (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
val = get(hObject,'Value');
handles.Pub.FuSe_mask = val;
if val
    disp('Selected FuSeISC for restricted brain volume. To create a custom mask, use function "create_custom_mask.m".')
    set(handles.FuSeMaskPath,'Enable','on')    
else
    disp('Selected FuSeISC for full brain volume.')
    set(handles.FuSeMaskPath,'Enable','off')
end
guidata(hObject, handles);
% Hint: get(hObject,'Value') returns toggle state of FuSe_mask


% --- Executes on button press in FuSe_multiK.
function FuSe_multiK_Callback(hObject, eventdata, handles)
% hObject    handle to FuSe_multiK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
val = get(hObject,'Value');
handles.Pub.FuSe_multiK = val;
if val
    set(handles.FuSe_minK,'Enable','on')
    set(handles.FuSe_stepK,'Enable','on')
    set(handles.FuSe_maxK,'Enable','on')
    set(handles.FuSe_K,'Enable','off')
else
    set(handles.FuSe_K,'Enable','on')
    set(handles.FuSe_minK,'Enable','off')
    set(handles.FuSe_stepK,'Enable','off')
    set(handles.FuSe_maxK,'Enable','off')
end
guidata(hObject, handles);

% Hint: get(hObject,'Value') returns toggle state of FuSe_multiK

function FuSe_minK_Callback(hObject, eventdata, handles)
% hObject    handle to FuSe_minK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
val = str2double(get(hObject,'String'));
handles.Pub.FuSe_minK = val;

guidata(hObject, handles);
% Hints: get(hObject,'String') returns contents of FuSe_minK as text
%        str2double(get(hObject,'String')) returns contents of FuSe_minK as a double

% --- Executes during object creation, after setting all properties.
function FuSe_minK_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FuSe_minK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function FuSe_stepK_Callback(hObject, eventdata, handles)
% hObject    handle to FuSe_stepK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
val = str2double(get(hObject,'String'));
handles.Pub.FuSe_stepK = val;

guidata(hObject, handles);
% Hints: get(hObject,'String') returns contents of FuSe_stepK as text
%        str2double(get(hObject,'String')) returns contents of FuSe_stepK as a double

% --- Executes during object creation, after setting all properties.
function FuSe_stepK_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FuSe_stepK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function FuSe_maxK_Callback(hObject, eventdata, handles)
% hObject    handle to FuSe_maxK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

val = str2double(get(hObject,'String'));
handles.Pub.FuSe_maxK = val;

guidata(hObject, handles);
% Hints: get(hObject,'String') returns contents of FuSe_maxK as text
%        str2double(get(hObject,'String')) returns contents of FuSe_maxK as a double

% --- Executes during object creation, after setting all properties.
function FuSe_maxK_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FuSe_maxK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function FuSeMaskPath_Callback(hObject, eventdata, handles)
% hObject    handle to FuSeMaskPath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
filename = get(hObject,'String');
if exist(filename,'file')
    handles.Pub.FuSeMaskPath = filename;
else
    disp(['File not found! ' filename])
    set(hObject,'String',['NOT FOUND: ' filename])
end

guidata(hObject, handles);
% Hints: get(hObject,'String') returns contents of FuSeMaskPath as text
%        str2double(get(hObject,'String')) returns contents of FuSeMaskPath as a double


% --- Executes during object creation, after setting all properties.
function FuSeMaskPath_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FuSeMaskPath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
