function calculateThresholdsPFsessions(Params)

% Compute critical thresholds from sumZPF null distributions for across
% session comparison.
%
% See also: RUNANALYSIS, INITPARAMS

% Last updated: 21.6.2011 by Jukka-Pekka Kauppi
% Tampere University of Technology
% Department of Signal Processing
% e-mail: jukka-pekka.kauppi@tut.fi

Priv = Params.PrivateParams;
Pub = Params.PublicParams;
sessComps = ((Priv.nrSessions)^2-(Priv.nrSessions))/2;

critVals = [0.05 0.025 0.01 0.001]; % note that the length of the critVals should be 4 in order 
                                        % not to mess up with saveCsvResults 
r = 0;
for s = 0:Pub.nrFreqBands
    for k = 1:sessComps
        try
            load([Priv.PFsessionDestination 'band' num2str(s) 'valsPFsessComp' num2str(k)])
            vals1 = vals1(:)';
            vals2 = vals2(:)';
            vals = [vals1 vals2];
            vals = fliplr(sort(vals));
            for m = 1:length(critVals)
                Th(m) = vals(1 + floor(length(vals)*critVals(m)));
            end
            save([Priv.PFsessionDestination 'ThPFBand' num2str(s) Priv.prefixSessComp num2str(k) 'win' num2str(r)],'critVals','Th')
        catch
            warning(['Could not find sum ZPF permutation distribution for session difference (in frequency band ' num2str(s) '), comparison ' num2str(k) ' -> significance test skipped.'])
        end
    end
end

for s = 0:Pub.nrFreqBands
    for k = 1:sessComps
        try
            load([Priv.PFsessionDestination 'band' num2str(s) 'pvalmaps3Dindvox' num2str(k)]);
            load([Priv.PFsessionDestination 'band' num2str(s) 'pvalmaps3D' num2str(k)]); % ,'pVs','indbmaskorig','PFsize')
            load([Priv.PFsessionDestination 'band' num2str(s) 'ZsumStat' num2str(k)])
            PFdata1D = PFdata3D(indbmaskorig);
            for m = 1:length(critVals)
               % [pthFDRid(m),pthFDRn(m)] = FDR(pVs,critVals(m));
               [pthFDRid(m)] = fdr_storey(pVs,critVals(m));
                if isnan(pthFDRid(m)) 
                    zthFDRid(m) = NaN;
                end
                idx = find(pVs == pthFDRid(m));
                if length(idx) > 1
                    idx = idx(1);
                end
                if length(idx) == 1
                     zthFDRid(m) = abs(PFdata1D(idx));
                end
%                 if isnan(pthFDRn(m)) 
%                     zthFDRn(m) = NaN;
%                 end
%                 idx = find(pVs == pthFDRn(m));
%                 if length(idx) > 1
%                     idx = idx(1);
%                 end
%                 if length(idx) == 1
%                      zthFDRn(m) = abs(PFdata1D(idx));
%                 end
                idx = find(pVs < critVals(m));
                if length(idx) > 0
                    zth_uncorrected(m) = min(abs(PFdata1D(idx)));
                else
                    zth_uncorrected(m) = NaN;
                end
                % non-parametric z and p
                [nonparam_pthFDRid(m)] = fdr_storey(pVsindvox,critVals(m));
                nonparam_zthFDRid(m) = -sqrt(2).*erfcinv(2*(1 - nonparam_pthFDRid(m)/2));
                % nonparam_zthFDRn(m) = -sqrt(2).*erfcinv(2*(1 - nonparam_pthFDRn(m)/2));
                nonparam_zth_uncorrected(m) = -sqrt(2).*erfcinv(2*(1 - critVals(m)/2));
            end
                
            save([Priv.PFsessionDestination 'fdr_ThPFBand' num2str(s) Priv.prefixSessComp num2str(k) 'win' num2str(r)],'critVals','zthFDRid','pthFDRid','zth_uncorrected','nonparam*');
        catch
            warning(['Could not find p-values for permutation distribution for session difference (in frequency band ' num2str(s) '), comparison ' num2str(k) ' -> significance test skipped.'])
        end
    end
end

if  Pub.clusterThreshold > 0 
    critVals = [0.05 0.025 0.01 0.001]; % note that the length of the critVals should be 4 in order 
                                        % not to mess up with saveCsvResults 
    r = 0;
    for s = 0:Pub.nrFreqBands
        for k = 1:sessComps
            try
            load([Priv.PFsessionDestination 'band' num2str(s) 'clustervalsPFsessComp' num2str(k)])
            cvalsNeg = cvalsNeg(:)';
            cvalsPos = cvalsPos(:)';
            cvalsNeg = fliplr(sort(cvalsNeg));
			cvalsPos = fliplr(sort(cvalsPos));
            for m = 1:length(critVals)
                cThNeg(m) = cvalsNeg(1 + floor(length(cvalsNeg)*critVals(m)));
				cThPos(m) = cvalsPos(1 + floor(length(cvalsPos)*critVals(m)));
            end
            save([Priv.PFsessionDestination 'clusterThPFBand' num2str(s) Priv.prefixSessComp num2str(k) 'win' num2str(r)],'critVals','cThNeg','cThPos')
            catch
            warning(['Could not find cluster sum ZPF permutation distribution for session difference (in frequency band ' num2str(s) '), comparison ' num2str(k) ' -> significance test skipped.'])
            end
        end
    end
end


% set session contrast maps non-writable:
% load([Pub.dataDestination 'memMaps'])
% for k = 0:Pub.nrFreqBands
%     for m = 1:sessComps
%         try
%             memMaps.(Priv.PFMapSessionName).whole.([Priv.prefixFreqBand num2str(k)]...
%                 ).cor.([Priv.prefixSessComp num2str(m)]).Writable = false;
%             memMaps.(Priv.PFmatMapSessionName).whole.([Priv.prefixFreqBand num2str(k)]...
%                 ).cor.([Priv.prefixSessComp num2str(m)]).Writable = false;
%         catch
%             lasterr
%         end
%     end
% end
% save([Pub.dataDestination 'memMaps'],'memMaps')
% 
