function cleanResultFolders(Params)
%function removes old results from folders:
%
% results
% PFsession 
%
% Juha Pajula, 22.10.2017


folders = { ...
    Params.PrivateParams.PFsessionDestination, ...
    Params.PrivateParams.resultsDestination, ...
    Params.PrivateParams.PFDestination, ...
    Params.PrivateParams.phaseDifDestination, ...
    Params.PrivateParams.statsDestination, ...
    Params.PrivateParams.subjectDestination, ...
    Params.PrivateParams.withinDestination, ...    
    };
selClean = logical([1 0 1 1 0 0 1]); %here should be some smart way to select the ones which have changed - JP
folders = folders(selClean);
disp('Cleaning the old runs from the folders...')
for k = 1:length(folders)
    if ~exist([folders{k} 'old/'],'dir')
        mkdir([folders{k} 'old/'])
    end
    try
        movefile([folders{k} '*.mat'],[folders{k} 'old/'])
        movefile([folders{k} '*.bin'],[folders{k} 'old/'])        
    %    delete([folders{k} '*.mat'])
        disp(['  Moved old files from folder: ' folders{k}])
    catch ME
        disp(['   ' ME.message])
    end
end
